% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_import.R
\name{HypeDataImport}
\alias{HypeDataImport}
\alias{ReadAquiferData}
\alias{ReadOutregions}
\alias{ReadBranchData}
\alias{ReadCropData}
\alias{ReadDamData}
\alias{ReadGlacierData}
\alias{ReadLakeData}
\alias{ReadMgmtData}
\alias{ReadPointSourceData}
\alias{ReadAllsim}
\alias{ReadForcKey}
\alias{ReadUpdate}
\title{Read HYPE data files}
\usage{
ReadAquiferData(
  filename = "AquiferData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadOutregions(
  filename = "Outregions.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadBranchData(
  filename = "BranchData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadCropData(
  filename = "CropData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadDamData(
  filename = "DamData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  quote = "",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadGlacierData(
  filename = "GlacierData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadLakeData(
  filename = "LakeData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  quote = "",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadMgmtData(
  filename = "MgmtData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  ...
)

ReadPointSourceData(
  filename = "PointSourceData.txt",
  verbose = TRUE,
  header = TRUE,
  na.strings = "-9999",
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  data.table = FALSE,
  ...
)

ReadAllsim(filename = "allsim.txt", na.strings = "-9999")

ReadForcKey(
  filename = "ForcKey.txt",
  sep = "\\t",
  encoding = c("unknown", "latin1", "UTF-8")
)

ReadUpdate(
  filename = "update.txt",
  header = TRUE,
  sep = "\\t",
  stringsAsFactors = FALSE,
  encoding = c("unknown", "latin1", "UTF-8"),
  data.table = FALSE,
  ...
)
}
\arguments{
\item{filename}{Path to and file name of HYPE data file file to import. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{verbose}{Logical, display message if columns contain \code{NA} values.}

\item{header}{\code{\link{read.table}} or \code{\link[data.table]{fread}} argument, with appropriate default for HYPE data file import.}

\item{na.strings}{See \code{header}.}

\item{sep}{See \code{header}.}

\item{stringsAsFactors}{See \code{header}.}

\item{encoding}{\code{\link{read.table}} argument. Specify character encoding when
importing files created under Windows (default encoding "latin1") in Linux (default encoding "UTF-8")
and vice versa.}

\item{...}{Other parameters passed to \code{\link{read.table}}.}

\item{quote}{See \code{header}.}

\item{data.table}{Logical, return data.table instead of data frame. \code{\link[data.table]{fread}} argument.}
}
\value{
Imported files are returned as data frames.
}
\description{
These are simple convenience wrapper functions to import various HYPE data files as data frame into R.
}
\details{
Hype data file imports, simple \code{\link{read.table}} or \code{\link[data.table]{fread}} wrappers with
formatting arguments set to match HYPE file specifications:
\itemize{
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:lakedata.txt}{LakeData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:damdata.txt}{DamData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:mgmtdata.txt}{MgmtData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:aquiferdata.txt}{AquiferData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:pointsourcedata.txt}{PointSourceData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:glacierdata.txt}{GlacierData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:cropdata.txt}{CropData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:branchdata.txt}{BranchData.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:outregions.txt}{Outregions.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:allsim.txt}{allsim.txt}
\item \href{http://www.smhi.net/hype/wiki/doku.php?id=start:hype_file_reference:update.txt}{update.txt}
}

In most files, HYPE requires \code{NA}-free input in required columns, but empty values are
allowed in additional comment columns. Informative warnings will be thrown if \code{NA}s are found during import.
}
\examples{
te <- ReadForcKey(filename = system.file("demo_model", "ForcKey.txt", package = "HYPEtools"))

}
