% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_PlotSubbasinRouting.R
\name{PlotSubbasinRouting}
\alias{PlotSubbasinRouting}
\title{Plot HYPE model subbasin routing.}
\usage{
PlotSubbasinRouting(
  map,
  map.subid.column = 1,
  gd = NULL,
  bd = NULL,
  plot.scale = TRUE,
  plot.searchbar = FALSE,
  weight = 0.5,
  opacity = 1,
  fillColor = "#4d4d4d",
  fillOpacity = 0.25,
  line.weight = 5,
  line.opacity = 1,
  font.size = 10,
  file = "",
  vwidth = 1424,
  vheight = 1000,
  html.name = ""
)
}
\arguments{
\item{map}{Path to file containing subbasin polygon GIS data (e.g. shapefile or geopackage) or a \code{SpatialPolygonsDataFrame}
or \code{sf} object. For large maps, a small/simplified polygon file should be used as larger files can take an excessive amount of time to render.}

\item{map.subid.column}{Integer, column index in the \code{map} 'data' \code{\link{slot}} holding SUBIDs (sub-catchment IDs).
Only required if providing GeoData information with \code{gd}.}

\item{gd}{Path to model GeoData.txt or a GeoData object from \code{\link{ReadGeoData}}. Only required if \code{map} does not contain SUBID and/or MAINDOWN fields.}

\item{bd}{Path to model BranchData.txt or a BranchData object from \code{\link{ReadBranchData}}. Only required if model has a BranchData.txt file.}

\item{plot.scale}{Logical, include a scale bar on the map.}

\item{plot.searchbar}{Logical, if \code{TRUE}, then a search bar will be included. See \code{\link[leaflet.extras:search-features]{leaflet.extras::addSearchFeatures()}}.}

\item{weight}{Numeric, weight of subbasin boundary lines. See \code{\link[leaflet:map-layers]{leaflet::addPolygons()}}.}

\item{opacity}{Numeric, opacity of subbasin boundary lines. See \code{\link[leaflet:map-layers]{leaflet::addPolygons()}}.}

\item{fillColor}{String, color of subbasin polygons. See \code{\link[leaflet:map-layers]{leaflet::addPolygons()}}.}

\item{fillOpacity}{Numeric, opacity of subbasin polygons. See \code{\link[leaflet:map-layers]{leaflet::addPolygons()}}.}

\item{line.weight}{Numeric, weight of routing lines. See \code{\link[leaflet:map-layers]{leaflet::addPolylines()}}.}

\item{line.opacity}{Numeric, opacity of routing lines. See \code{\link[leaflet:map-layers]{leaflet::addPolylines()}}.}

\item{font.size}{Numeric, font size (px) for map subbasin labels.}

\item{file}{Save map to an image file by specifying the path to the desired output file using this argument. File extension must be specified.
See \code{\link[mapview:mapshot]{mapview::mapshot()}}.
You may need to run \code{\link[webshot:install_phantomjs]{webshot::install_phantomjs()}} the first time you save a map to an image file.}

\item{vwidth}{Numeric, width of the exported map image in pixels. See \code{\link[webshot:webshot]{webshot::webshot()}}.}

\item{vheight}{Numeric, height of the exported map image in pixels. See \code{\link[webshot:webshot]{webshot::webshot()}}.}

\item{html.name}{Save map to an interactive HTML file by specifying the path to the desired output file using this argument. File extension must be specified.
See \code{\link[htmlwidgets:saveWidget]{htmlwidgets::saveWidget()}}.}
}
\value{
Returns an interactive Leaflet map.
}
\description{
Plot routing of subbasins for a HYPE model on an interactive map.
}
\details{
\code{PlotSubbasinRouting} generates an interactive Leaflet map with lines indicating the routing of flow between subbasins. GeoData information only needs
to be provided if the \code{map} GIS data does not include SUBID and/or MAINDOWN fields. BranchData information only needs to be provided if model has a
BranchData.txt file. Subbasin routing lines are randomly assigned a color using \code{\link[randomcoloR:distinctColorPalette]{randomcoloR::distinctColorPalette()}}.
}
\examples{
\dontrun{
PlotSubbasinRouting(
  map = system.file("demo_model",
                    "gis", "Nytorp_map.gpkg",
                    package = "HYPEtools"
  ),
  gd = system.file("demo_model", "GeoData.txt", package = "HYPEtools"),
  map.subid.column = 25
)
}

}
