% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_HypeAttrAccess.R
\name{HypeAttrAccess}
\alias{HypeAttrAccess}
\alias{datetime}
\alias{datetime<-}
\alias{hypeunit}
\alias{hypeunit<-}
\alias{obsid}
\alias{obsid<-}
\alias{outregid}
\alias{outregid<-}
\alias{subid}
\alias{subid<-}
\alias{timestep}
\alias{timestep<-}
\alias{variable}
\alias{variable<-}
\title{Quickly query and set HYPE-specific attributes}
\usage{
datetime(x)

datetime(x) <- value

hypeunit(x)

hypeunit(x) <- value

obsid(x)

obsid(x) <- value

outregid(x)

outregid(x) <- value

subid(x)

subid(x) <- value

timestep(x)

timestep(x) <- value

variable(x)

variable(x) <- value
}
\arguments{
\item{x}{Object whose attribute is to be accessed}

\item{value}{Value to be assigned}
}
\value{
The extractor functions return the value of the respective attribute or \code{NULL} if no matching attribute is found.
}
\description{
These are simple convenience wrapper functions to quickly query and assign values of attributes which are added to HYPE data
on import.
}
\details{
These functions are just shortcuts for \code{\link{attr}}.
}
\examples{
te <- ReadBasinOutput(filename = system.file("demo_model", "results",
"0003587.txt", package = "HYPEtools"))
hypeunit(te)
timestep(te)
subid(te)

}
