% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_OutletSubids.R
\name{OutletSubids}
\alias{OutletSubids}
\title{Find all Outlet SUBIDs of a model domain}
\usage{
OutletSubids(gd)
}
\arguments{
\item{gd}{A data frame, with two columns \code{subid} and \code{maindown}, (not case-sensitive).
Typically a 'GeoData.txt' file imported using \code{\link{ReadGeoData}}.}
}
\value{
\code{OutletSubids} returns a vector of outlet SUBIDs.
}
\description{
Function to find all outlet SUBIDs of a HYPE model domain.
}
\details{
\code{OutletSubids} finds all outlet SUBIDs of a model domain as provided in a 'GeoData.txt' file, i.e. all SUBIDs from which
stream water leaves the model domain.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
OutletSubids(gd = te)

}
\seealso{
\code{\link{AllDownstreamSubids}}, \code{\link{OutletIds}}
}
