% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_confidence_limit_values.R
\name{calculate_confidence_limit_values}
\alias{calculate_confidence_limit_values}
\title{Calculate the value of confidence limit}
\usage{
calculate_confidence_limit_values(
  calc_dat,
  confidence_limit = 0.98,
  theoretical = FALSE,
  relative = TRUE
)
}
\arguments{
\item{calc_dat}{processed data from DynamX file - using prepare_dataset}

\item{confidence_limit}{confidence limit chosen by user - from range [0, 1].}

\item{theoretical}{logical value to determine if plot is theoretical or not.}

\item{relative}{logical value to determine if values are relative or absolute.}
}
\value{
range of confidence limit interval
}
\description{
Calculates confidence limit values for prepared dataset, based on chosen parameters.
}
\details{
...
}
\examples{
# load example data
dat <- read_hdx(system.file(package = "HaDeX", "HaDeX/data/KD_180110_CD160_HVEM.csv"))

# prepare dataset for states `CD160` and `CD160_HVEM` in given time parameters 
calc_dat <- prepare_dataset(dat,
                            in_state_first = "CD160_0.001",
                            chosen_state_first = "CD160_1",
                            out_state_first = "CD160_1440",
                            in_state_second = "CD160_HVEM_0.001",
                            chosen_state_second = "CD160_HVEM_1",
                            out_state_second = "CD160_HVEM_1440")   
                            
# calculates confidence limits for prepared data  
calculate_confidence_limit_values(calc_dat = calc_dat,
                                  confidence_limit = 0.99,
                                  theoretical = FALSE, 
                                  relative = TRUE)                          
                              
}
\references{
Houde, D., Berkowitz, S.A., and Engen, J.R. (2011). 
The Utility of Hydrogen/Deuterium Exchange Mass Spectrometry in 
Biopharmaceutical Comparability Studies. J Pharm Sci 100, 2071–2086.
}
\seealso{
\code{\link{read_hdx}} \code{\link{prepare_dataset}}
}
