if (interactive()) pkgload::load_all(".")
testthat::context("Testing binary classes")

data(ht01.twoclass, package = "HandTill2001")

testthat::test_that("create object", {
  result <- methods::new("bincap", response = as.factor(ht01.twoclass$observed),
                predicted = ht01.twoclass$predicted)
  expectation <- methods::new("bincap", predicted = c(0.26184254779443, 0.00380913410144982, 
    0.321677006839984, 0.524681727434473, 0.327251730482903, 0.179129374907245, 
    0.123085109644385, 0.226791593722603, 0.131318297822531, 0.464952302283684, 
    0.253027466251894, 0.0865426590537234, 0.770260333528018, 0.449343707267034, 
    0.3822784517639, 0.3822784517639, 0.190648249978874, 0.206074521054498, 
    0.574986211131229, 0.149065507151179, 0.0105776813587371, 0.123843481411173, 
    0.00751859654844662, 0.286591788043499, 0.413137464705569, 0.133598922541858, 
    0.268229511524883, 0.0159424996990191, 0.220816857416213, 0.193060852961418, 
    0.193060852961418, 0.684533978800258, 0.308742579587741, 0.0485138450436665, 
    0.224353429567201, 0.0415298260762608, 0.563840707889609, 0.428253477568856, 
    0.00478316340495947, 0.124631973059061, 0.202339561888927, 0.1733196651837, 
    0.0915969356825695, 0.0948615247642624, 0.407500511127207, 0.407500511127207, 
    0.00847206127903622, 0.137487636675909, 0.150308558747987, 0.531920397368761, 
    0.51534931323224, 0.189591025305376, 0.312402717809349, 0.0719138649496634, 
    0.183924461578509, 0.165932189001328, 0.364672096538307, 0.192598704613336, 
    0.236860031223215, 0.151543027214246, 0.151543027214246, 0.18570266631091, 
    0.266896755412734, 0.210910423628953, 0.733498255728962, 0.633876502944091, 
    0.150308558747987, 0.00640395616745807, 0.753861712469654, 0.406875395446774, 
    0.757333012478498, 0.0177468432219946, 0.229938546573611, 0.160369600013437, 
    0.206852012394373, 0.0200751393118814, 0.0647314003762375, 0.0785033429728988, 
    0.31937733699656, 0.062049242040699, 0.0972309842499661, 0.164040334396254, 
    0.364197540944933, 0.159907863679878, 0.205738481541406, 0.276302184972239, 
    0.216487182712615, 0.183409720552617, 0.193383129404623, 0.108501295460785, 
    0.185579452572251, 0.247353314618411, 0.251815839778992, 0.833816151710127, 
    0.206852012394373, 0.0514723063558717, 0.0355387533710637, 0.203938092533554, 
    0.203938092533554, 0.0456120701529537, 0.122053670528405, 0.487515090320392, 
    0.634110597107543, 0.131605310370938, 0.180006156397163, 0.176826644401098, 
    0.073673501098173, 0.0859999408384223, 0.722914551838928, 0.457920304068826, 
    0.0028357979244613, 0.159877951652237, 0.0504406389391247, 0.254686201969671, 
    0.147431393476472, 0.0569358639622538, 0.0932039480161822, 0.246805925510796, 
    0.102519307977947, 0.273437604280284, 0.0687618844310284, 0.132621589161422, 
    0.139898827502498, 0.175291281237315, 0.0852341338943083, 0.0150308159099421, 
    0.0701554475566242, 0.307506831807049, 0.109548621610509, 0.0171245976780972, 
    0.790877113397093, 0.130480813121514, 0.735364935520731, 0.942295814983955, 
    0.801064163735424, 0.168161861628483, 0.548976129156063, 0.314424650827267, 
    0.647273137880823, 0.502744992608331, 0.616753876026632, 0.775768539951366, 
    0.261777832971678, 0.155737590412012, 0.552768777662212, 0.419895798533574, 
    0.345509347172716, 0.601847780022893, 0.250784393477229, 0.549923496147735, 
    0.482190204554574, 0.552340851886047, 0.321482857867196, 0.792227614324848, 
    0.17067419755069, 0.573358577437788, 0.571500541526345, 0.508551851793823, 
    0.651870353769712, 0.495124054014004, 0.318830170767606, 0.401977932239847, 
    0.215479402473153, 0.0964056716903714, 0.706138473462752, 0.66941427708885, 
    0.757717486253353, 0.360284179316179, 0.481562606628934, 0.155739762581408, 
    0.0644356231229483, 0.314965228255553, 0.467914595019454, 0.506597870535335, 
    0.215905420210607, 0.756068904186095, 0.193416558533143, 0.784901076757499, 
    0.77806007207721, 0.625841137981421, 0.641969703570936, 0.453514866756243, 
    0.153279316467635, 0.680897715531475, 0.131625040256969, 0.873066811764239, 
    0.505010131779594, 0.468685206080448, 0.85989898806339), true = character(0), 
      response = structure(c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 
      1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L
      ), .Label = c("0", "1"), class = "factor")
    )
  testthat:::expect_equal(result, expectation)
})



testthat::expect_error(
  methods::new("bincap",
      response = ht01.twoclass$observed,
      predicted = ht01.twoclass$predicted
      ), 
 regexp = "response.*should be or extend class \"factor\""
)

testthat::expect_error(
  methods::new("bincap",
    response = as.factor(ht01.twoclass$observed),
    predicted = as.data.frame(ht01.twoclass$predicted)
  ),
 regexp = "predicted.*should be or extend class \"numeric\""
)

testthat::expect_error(
  methods::new("bincap",
    true = 1
  ), 
 regexp = "true.*should be or extend class \"character\""
)


testthat::context("Testing binary classes")

data(ht01.multipleclass, package = "HandTill2001")

testthat::test_that("create object", {
  result <- methods::new("multcap",
                response = ht01.multipleclass$observed,
                predicted = as.matrix(ht01.multipleclass[, 
                                      levels(ht01.multipleclass$observed)]))
  expectation <- methods::new("multcap", predicted = structure(c(0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.75, 0.75, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.75, 0.75, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.04, 0.75, 0.75, 0.75, 0.75, 
    0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 
    0.04, 0.04, 0.04, 0.04, 0.04, 0, 0.04, 0.04, 0.04, 0.04, 0.04, 
    0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0, 0.0204081632653061, 
    0.0384615384615385, 0.0204081632653061, 0.0204081632653061, 0.0384615384615385, 
    0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 
    0.0384615384615385, 0.0204081632653061, 0, 0.0204081632653061, 
    0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 0, 
    0, 0.0384615384615385, 0.0384615384615385, 0, 0.0204081632653061, 
    0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 
    0.0204081632653061, 0.0384615384615385, 0.0204081632653061, 0.0204081632653061, 
    0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 
    0, 0.0204081632653061, 0.0204081632653061, 0, 0, 0.0204081632653061, 
    0.0204081632653061, 0.0204081632653061, 0, 0.0204081632653061, 
    0.0204081632653061, 0.0204081632653061, 0, 0, 0.0204081632653061, 
    0, 0.0204081632653061, 0.0204081632653061, 0.0204081632653061, 
    0.0204081632653061, 0.0204081632653061, 0, 0.0204081632653061, 
    0.0204081632653061, 0.0204081632653061, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0.0384615384615385, 0, 0.0384615384615385, 0.0384615384615385, 
    0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0.0204081632653061, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0.0384615384615385, 0.0384615384615385, 0.0204081632653061, 0.0204081632653061, 
    0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0.0204081632653061, 0, 0, 0, 0, 0.125, 0.0833333333333333, 0.125, 
    0.125, 0.125, 0.125, 0, 0, 0, 0, 0.0384615384615385, 0.0384615384615385, 
    0.0384615384615385, 0, 0.0384615384615385, 0.0384615384615385, 
    0.0384615384615385, 0.0204081632653061, 0.0384615384615385, 0, 
    0, 0, 0.0833333333333333, 0.125, 0.125, 0, 0.0384615384615385, 
    0, 0, 0, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0.0384615384615385, 0.0204081632653061, 0.0384615384615385, 0.0384615384615385, 
    0, 0.0204081632653061, 0, 0, 0, 0, 0.0384615384615385, 0, 0, 
    0, 0, 0, 0, 0, 0.0384615384615385, 0.0384615384615385, 0.0384615384615385, 
    0, 0, 0.96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0833333333333333, 
    0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 
    0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 
    0.0384615384615385, 0.0384615384615385, 0.0204081632653061, 0.0833333333333333, 
    0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 
    0.96, 0.125, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 0.96, 
    0.96, 0.96, 0.96, 0.96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.75, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.75, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.75, 0.75, 
    0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0.75, 0, 0, 0, 0.75, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0.214285714285714, 0, 0.0769230769230769, 0, 0, 0.0769230769230769, 
    0, 0, 0, 0, 0.0769230769230769, 0, 0.5, 0, 0, 0, 0, 0.214285714285714, 
    0.214285714285714, 0.0769230769230769, 0.0769230769230769, 0.214285714285714, 
    0, 0, 0, 0, 0, 0, 0.0769230769230769, 0, 0, 0, 0, 0, 0, 0.5, 
    0, 0, 0.214285714285714, 0.214285714285714, 0, 0, 0, 0.214285714285714, 
    0, 0, 0, 0.214285714285714, 0.214285714285714, 0, 0.214285714285714, 
    0, 0, 0, 0, 0, 0.5, 0, 0, 0, 0.214285714285714, 0.214285714285714, 
    0.214285714285714, 0.214285714285714, 0.214285714285714, 0.214285714285714, 
    0.214285714285714, 0.214285714285714, 0.214285714285714, 0.214285714285714, 
    0.0769230769230769, 0, 0.0769230769230769, 0.0769230769230769, 
    0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0.5, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0.5, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0.0769230769230769, 0.0769230769230769, 0, 0, 0.0769230769230769, 
    0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 0, 
    0.214285714285714, 0.214285714285714, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0, 0.0769230769230769, 0.5, 0, 0, 0, 0, 0, 0, 0.0769230769230769, 
    0, 0, 0, 0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 
    0.0769230769230769, 0, 0.0769230769230769, 0.0769230769230769, 
    0.5, 0, 0.214285714285714, 0.5, 0.5, 0.5, 0.0769230769230769, 
    0.214285714285714, 0.214285714285714, 0.5, 0.5, 0.5, 0.5, 0.214285714285714, 
    0.0769230769230769, 0.0769230769230769, 0.0769230769230769, 0.214285714285714, 
    0.214285714285714, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0.0769230769230769, 0.0769230769230769, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0.714285714285714, 0.836734693877551, 0.115384615384615, 
    0.836734693877551, 0.836734693877551, 0.115384615384615, 0.836734693877551, 
    0.836734693877551, 0.836734693877551, 0.836734693877551, 0.115384615384615, 
    0.836734693877551, 0.214285714285714, 0.836734693877551, 0.836734693877551, 
    0.836734693877551, 0.836734693877551, 0.714285714285714, 0.714285714285714, 
    0.115384615384615, 0.115384615384615, 0.714285714285714, 0.836734693877551, 
    0.836734693877551, 0.836734693877551, 0.836734693877551, 0.836734693877551, 
    0.836734693877551, 0.115384615384615, 0.836734693877551, 0.836734693877551, 
    0.836734693877551, 0.836734693877551, 0.836734693877551, 0.836734693877551, 
    0.214285714285714, 0.836734693877551, 0.836734693877551, 0.714285714285714, 
    0.714285714285714, 0.836734693877551, 0.836734693877551, 0.836734693877551, 
    0.714285714285714, 0.836734693877551, 0.836734693877551, 0.836734693877551, 
    0.714285714285714, 0.714285714285714, 0.836734693877551, 0.714285714285714, 
    0.836734693877551, 0.836734693877551, 0.836734693877551, 0.836734693877551, 
    0.836734693877551, 0.214285714285714, 0.836734693877551, 0.836734693877551, 
    0.836734693877551, 0.714285714285714, 0.714285714285714, 0.714285714285714, 
    0.714285714285714, 0.714285714285714, 0.714285714285714, 0.714285714285714, 
    0.714285714285714, 0.714285714285714, 0.714285714285714, 0.115384615384615, 
    0, 0.115384615384615, 0.115384615384615, 0.115384615384615, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0.214285714285714, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0.214285714285714, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0.115384615384615, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0.836734693877551, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0.115384615384615, 0.115384615384615, 
    0.836734693877551, 0.836734693877551, 0.115384615384615, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0.836734693877551, 0.714285714285714, 
    0.714285714285714, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0, 0.115384615384615, 0.115384615384615, 
    0.115384615384615, 0.836734693877551, 0.115384615384615, 0.214285714285714, 
    0, 0, 0, 0, 0, 0, 0.115384615384615, 0, 0, 0, 0.115384615384615, 
    0.115384615384615, 0.115384615384615, 0.115384615384615, 0.836734693877551, 
    0.115384615384615, 0.115384615384615, 0.214285714285714, 0.836734693877551, 
    0.714285714285714, 0.214285714285714, 0.214285714285714, 0.214285714285714, 
    0.115384615384615, 0.714285714285714, 0.714285714285714, 0.214285714285714, 
    0.214285714285714, 0.214285714285714, 0.214285714285714, 0.714285714285714, 
    0.115384615384615, 0.115384615384615, 0.115384615384615, 0.714285714285714, 
    0.714285714285714, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0.115384615384615, 0.115384615384615, 
    0.836734693877551, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0714285714285714, 0.142857142857143, 
    0.769230769230769, 0.142857142857143, 0.142857142857143, 0.769230769230769, 
    0.142857142857143, 0.142857142857143, 0.142857142857143, 0.142857142857143, 
    0.769230769230769, 0.142857142857143, 0.285714285714286, 0.142857142857143, 
    0.142857142857143, 0.142857142857143, 0.142857142857143, 0.0714285714285714, 
    0.0714285714285714, 0.769230769230769, 0.769230769230769, 0.0714285714285714, 
    0.142857142857143, 0.142857142857143, 0.142857142857143, 0.142857142857143, 
    0.142857142857143, 0.142857142857143, 0.769230769230769, 0.142857142857143, 
    0.142857142857143, 0.142857142857143, 0.142857142857143, 0.142857142857143, 
    0.142857142857143, 0.285714285714286, 0.142857142857143, 0.142857142857143, 
    0.0714285714285714, 0.0714285714285714, 0.142857142857143, 0.142857142857143, 
    0.142857142857143, 0.0714285714285714, 0.142857142857143, 0.142857142857143, 
    0.142857142857143, 0.0714285714285714, 0.0714285714285714, 0.142857142857143, 
    0.0714285714285714, 0.142857142857143, 0.142857142857143, 0.142857142857143, 
    0.142857142857143, 0.142857142857143, 0.285714285714286, 0.142857142857143, 
    0.142857142857143, 0.142857142857143, 0.0714285714285714, 0.0714285714285714, 
    0.0714285714285714, 0.0714285714285714, 0.0714285714285714, 0.0714285714285714, 
    0.0714285714285714, 0.0714285714285714, 0.0714285714285714, 0.0714285714285714, 
    0.769230769230769, 1, 0.769230769230769, 0.769230769230769, 0.769230769230769, 
    0.769230769230769, 0.769230769230769, 0.769230769230769, 0.285714285714286, 
    0.769230769230769, 0.769230769230769, 0.769230769230769, 0.285714285714286, 
    0.769230769230769, 0.769230769230769, 0.769230769230769, 0.769230769230769, 
    0.769230769230769, 0.769230769230769, 0.769230769230769, 0.142857142857143, 
    0.769230769230769, 0.769230769230769, 0.769230769230769, 0.769230769230769, 
    0.769230769230769, 0.142857142857143, 0.142857142857143, 0.769230769230769, 
    0.769230769230769, 0.769230769230769, 0.769230769230769, 0.142857142857143, 
    0.0714285714285714, 0.0714285714285714, 0.25, 0.25, 0.875, 0.166666666666667, 
    0.875, 0.875, 0.875, 0.875, 1, 1, 1, 1, 0.769230769230769, 0.769230769230769, 
    0.769230769230769, 1, 0.769230769230769, 0.769230769230769, 0.769230769230769, 
    0.142857142857143, 0.769230769230769, 0.285714285714286, 0.25, 
    0.25, 0.166666666666667, 0.875, 0.875, 1, 0.769230769230769, 
    1, 1, 1, 0.769230769230769, 0.769230769230769, 0.769230769230769, 
    0.769230769230769, 0.142857142857143, 0.769230769230769, 0.769230769230769, 
    0.285714285714286, 0.142857142857143, 0.0714285714285714, 0.285714285714286, 
    0.285714285714286, 0.285714285714286, 0.769230769230769, 0.0714285714285714, 
    0.0714285714285714, 0.285714285714286, 0.285714285714286, 0.285714285714286, 
    0.285714285714286, 0.0714285714285714, 0.769230769230769, 0.769230769230769, 
    0.769230769230769, 0.0714285714285714, 0.0714285714285714, 0, 
    0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 0.25, 
    0.25, 0.166666666666667, 0.166666666666667, 0.166666666666667, 
    0.166666666666667, 0.166666666666667, 0.166666666666667, 0.166666666666667, 
    0.166666666666667, 0.166666666666667, 0.769230769230769, 0.769230769230769, 
    0.142857142857143, 0.166666666666667, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0.875, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), .Dim = c(214L, 
    6L), .Dimnames = list(c("1", "2", "3", "4", "5", "6", "7", "8", 
    "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", 
    "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", 
    "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", 
    "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", 
    "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", 
    "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", 
    "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", 
    "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", 
    "97", "98", "99", "100", "101", "102", "103", "104", "105", "106", 
    "107", "108", "109", "110", "111", "112", "113", "114", "115", 
    "116", "117", "118", "119", "120", "121", "122", "123", "124", 
    "125", "126", "127", "128", "129", "130", "131", "132", "133", 
    "134", "135", "136", "137", "138", "139", "140", "141", "142", 
    "143", "144", "145", "146", "147", "148", "149", "150", "151", 
    "152", "153", "154", "155", "156", "157", "158", "159", "160", 
    "161", "162", "163", "164", "165", "166", "167", "168", "169", 
    "170", "171", "172", "173", "174", "175", "176", "177", "178", 
    "179", "180", "181", "182", "183", "184", "185", "186", "187", 
    "188", "189", "190", "191", "192", "193", "194", "195", "196", 
    "197", "198", "199", "200", "201", "202", "203", "204", "205", 
    "206", "207", "208", "209", "210", "211", "212", "213", "214"
    ), c("Con", "Head", "Tabl", "Veh", "WinF", "WinNF"))), response = structure(c(5L, 
    5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 
    5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 
    5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 
    5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 
    5L, 5L, 5L, 5L, 5L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 
    6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 
    6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 
    6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 
    6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 
    6L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 
    4L, 4L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 3L, 
    3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 
    2L, 2L, 2L, 2L, 2L), .Label = c("Con", "Head", "Tabl", "Veh", 
    "WinF", "WinNF"), class = "factor"))
  testthat:::expect_equal(result, expectation)
  }
)

testthat::expect_error(
  methods::new("multcap",
    response = as.numeric(ht01.multipleclass$observed),
    predicted = as.matrix(ht01.multipleclass[, levels(ht01.multipleclass$observed)])
  ),
  regexp = "response.*should be or extend class \"factor\""
)

testthat::expect_error(
  methods::new("multcap", response = ht01.multipleclass$observed,
      predicted = ht01.multipleclass[, levels(ht01.multipleclass$observed)]),
  regexp = "predicted.*should be or extend class \"matrix\""
)

testthat::expect_error(
  methods::new("multcap", true = 1),
  regexp = 'invalid name for slot of class .*: true'
)

testthat::context("Test for input checks")

po <- ht01.multipleclass[, levels(ht01.multipleclass$observed)]
ro <- ht01.multipleclass$observed
i <- c(1, 73, 157, 170, 182, 186)

testthat::test_that("create object on subset", {
  p <- po[i, ]
  r <- ro[i]
  result <- multcap(
    response = r,
    predicted = as.matrix(p)
  )
  expectation <- methods::new("multcap", predicted = structure(c(0, 0, 0, 0.75, 0, 0, 0, 
    0.0384615384615385, 0, 0, 0.0833333333333333, 0.0384615384615385, 
    0, 0, 0, 0, 0.75, 0, 0.214285714285714, 0.0769230769230769, 0.5, 
    0, 0, 0.0769230769230769, 0.714285714285714, 0.115384615384615, 
    0.214285714285714, 0, 0, 0.115384615384615, 0.0714285714285714, 
    0.769230769230769, 0.285714285714286, 0.25, 0.166666666666667, 
    0.769230769230769), .Dim = c(6L, 6L), .Dimnames = list(c("1", 
    "73", "157", "170", "182", "186"), c("Con", "Head", "Tabl", "Veh", 
    "WinF", "WinNF"))), response = structure(c(5L, 6L, 4L, 1L, 3L, 
    2L), .Label = c("Con", "Head", "Tabl", "Veh", "WinF", "WinNF"
    ), class = "factor"))
    testthat:::expect_equal(result, expectation)
    }
)

testthat::test_that("extraneous response levels", {
  r <- ro[i]
  p <- po[i, ]
  levels(r) <- c(levels(r), "foo", "bar")
  testthat::expect_warning(
                           HandTill2001::multcap(
                                   response = r,
                                   predicted = as.matrix(p)
                                   ),
                           regexp = ".*of response unmatched by predicted."
                           )
})

testthat::test_that("response values unmatched in predicted", {
  r <- ro[i]
  p <- po[i, 1:5]
  testthat::expect_warning(
    testthat::expect_error(
      HandTill2001::multcap(response = r, predicted = as.matrix(p)))
   )
})

testthat::test_that("predicted columns unmatched in predicted", {
  r <- ro[i]
  p <- po[i, ]
  p$foo <- NA
  testthat::expect_error(
    HandTill2001::multcap(response = r, predicted = as.matrix(p)))
})
