% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDyads_or_Triads.R
\name{getFullTriads}
\alias{getFullTriads}
\title{Getter for all full triads}
\usage{
getFullTriads(data.in = stop("No data given!", call. = FALSE),
  file.out = "my_data_onlyTriads", dir.out = ".", overwrite = NULL)
}
\arguments{
\item{data.in}{The data object (in format as the output of \link{genDataRead}); note
that the design of the data is assumed to be triad.}

\item{file.out}{The base for the output filename (default: "my_data_onlyTriads").}

\item{dir.out}{The path to the directory where the output files will be saved.}

\item{overwrite}{Whether to overwrite the output files: if NULL (default), will prompt
the user to give answer; set to TRUE, will automatically overwrite any existing files;
and set to FALSE, will stop if the output files exist.}
}
\value{
A list object with three elements:
  \itemize{
    \item \emph{cov.data} - a \code{data.frame} with covariate data (if available in
       the input file)
    \item \emph{gen.data} - a list with chunks of the genetic data; the data is divided
       column-wise, using 10,000 columns per chunk; each element of this list is a
       \link[ff]{ff} matrix
    \item \emph{aux} - a list with meta-data and important parameters.
  }
  This now contains only the selected subset of data.
}
\description{
Wrapper function for \link{genDataGetPart} that returns a subset of the data containing 
 only full triads (where all, the child, the mother and the father have genetic data).
}
