% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.search.R
\name{local.search}
\alias{local.search}
\title{Return path of file searched for in local disk based on its file name}
\usage{
local.search(pattern, directory = "", folder = "$HOME", intern = TRUE,
  ignore.stdout = FALSE, ignore.stderr = TRUE)
}
\arguments{
\item{pattern}{The name of file to be searched for. Can use wildcards *}

\item{directory}{The path of directory to be explored in for Windows}

\item{folder}{The path of folder to be explored in for Unix based systems}

\item{intern}{A logical (not NA) which indicates whether to capture the output of the command as an R character vector (see system()).}

\item{ignore.stdout}{a logical (not NA) indicating whether messages written to 'stdout' should be ignored  (see system()).}

\item{ignore.stderr}{a logical (not NA) indicating whether messages written to 'stderr' should be ignored  (see system()).}
}
\value{
A vector with paths
}
\description{
Return path of file searched for in local disk based on its file name.\cr
It has been tested only with Windows XP and MacOSX. In MacOSX, you must have created the locate database first. Use OnyX utilities for this purpose.
}
\details{
local.search() returns path of file serached in local disk based on its file name
}
\examples{
\dontrun{
RnwFiles <- local.search("*.Rnw")
nc.files <- local.search("*.nc", folder=paste0("'",getwd(),"'"))
}
}
\author{
Marc Girondot
}
