% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RM_duplicate.R
\name{RM_duplicate}
\alias{RM_duplicate}
\title{Duplicate a results managment within an object.}
\usage{
RM_duplicate(
  x = stop("An object with results managment must be provided"),
  RM = "RM",
  RMnamefrom = 1,
  RMnameto = 2
)
}
\arguments{
\item{x}{The object to duplicate a results managment}

\item{RM}{The name of results managment stored}

\item{RMnamefrom}{The name of the results managment to be duplicated}

\item{RMnameto}{The new name of the results managment}
}
\value{
The original object with a duplicated results managment.
}
\description{
RM_duplicate duplicates a results managment within an object.
}
\details{
RM_duplicate duplicates a results managment within an object
}
\examples{
\dontrun{
library("HelpersMG")
# Let an object of class objclass being created
obj <- list(A=100, name="My object")
class(obj) <- "objclass"
# And now I create a RM to this object
obj <- RM_add(x=obj, RMname="NewAnalysis1")
RM_list(obj)
obj <- RM_duplicate(x=obj, RMnamefrom="NewAnalysis1", RMnameto="NewAnalysis2")
RM_list(obj)
}
}
\seealso{
Other Results Managment: 
\code{\link{RM_add}()},
\code{\link{RM_delete}()},
\code{\link{RM_get}()},
\code{\link{RM_list}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Results Managment}
