% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluateMassTargetedForFlux.R
\name{EvaluateMassTargetedForFlux}
\alias{EvaluateMassTargetedForFlux}
\title{EvaluateMassTargetedForFlux.}
\usage{
EvaluateMassTargetedForFlux(xg = NULL, dat = NULL, tp = NULL, gr = NULL,
  mz = NULL, rt = NULL, dmz_M0 = 0.01, drt_M0 = 10, dmz = 0.05,
  drt = 0.5, mz_iso = 1.003355, ng = NULL, mfrow = NULL,
  pdf_file = "SinglePeak.pdf", xlsx_file = "SinglePeak.xlsx",
  testing = FALSE)
}
\arguments{
\item{xg}{xcmsSet object with group information.}

\item{dat}{Raw data. List of xcmsRaw's.}

\item{tp}{Timepoint (numeric information).}

\item{gr}{Line/Group (class information).}

\item{mz}{Mass of M+H.}

\item{rt}{Retention time.}

\item{dmz_M0}{Allowed mz deviation in milli Dalton to find M0 within xcmsSet.}

\item{drt_M0}{Allowed rt deviation in seconds to find M0 within xcmsSet.}

\item{dmz}{Allowed mz deviation in milli Dalton for a corresponding candidate relative to M0.}

\item{drt}{Allowed rt deviation in seconds for a corresponding candidate relative to M0.}

\item{mz_iso}{The isotopic mass shift under investigation (e.g. 1.003355 for 13C experiments)}

\item{ng}{Limit analysis to a selected isotope? Specify ng=3 to specifically check M0 vs M+3. Leave NULL to check all present.}

\item{mfrow}{Layout for flute plotting. NULL for automatic layout.}

\item{pdf_file}{PDF output.}

\item{xlsx_file}{XLSX output.}

\item{testing}{testing (cf \link{EvaluateCandidateListAgainstRawData}).}

\item{gmd}{GMD.}
}
\value{
Nothing.
}
\description{
\code{EvaluateMassTargetedForFlux} will work on mz, rt information and evaluate a peak targeted for flux.
}
\details{
This function .
}
\keyword{internal}
