% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluateCandidate.R
\name{EvaluateCandidate}
\alias{EvaluateCandidate}
\title{EvaluateCandidate.}
\usage{
EvaluateCandidate(x = NULL, tp = NULL, gr = NULL, dat = NULL,
  mz_iso = 1.003355, dmz = 0.005, drt = 0.5, dEcut = 0,
  Pcut = 0.01, Icut = 1000, flux_lib = NULL,
  flux_lib_masses = NULL, flux_lib_rt_dev = 5, method = c("APCI",
  "ESI")[1])
}
\arguments{
\item{x}{A single row from results dataframe provided by \link{EvaluatePairsFromXCMSSet}.}

\item{tp}{Timepoint.}

\item{gr}{Group.}

\item{dat}{list of xcms raws for deconvolution and plotting.}

\item{mz_iso}{The isotopic mass shift under investigation (e.g. 1.003355 for 13C experiments)}

\item{dmz}{Allowed mz deviation in milli Dalton for a BPCs (passed on to getMultipleBPC, can be a matrix).}

\item{drt}{Allowed rt deviation in seconds for BPCs.}

\item{dEcut}{Minimum required change in enrichment before a candidate ID is assigned.}

\item{Pcut}{Maximum allowed P value before a candidate ID is assigned.}

\item{Icut}{Minimum required median peak intensity (mz1 and mz2) before a candidate ID is assigned.}

\item{flux_lib}{Flux Library.}

\item{flux_lib_masses}{Masses from library spectra as a list.}

\item{flux_lib_rt_dev}{Allow this time deviation to call a metabolite identified.}

\item{method}{Either APCI or ESI. Choice will modify some internal parameters and checks performed.}
}
\value{
A list with all important information including deconvoluted spectrum (from raw data) and linear model analysis.
}
\description{
\code{EvaluateCandidate} will analyze a mass pair (mz1, mz2) for changes due to 13C incorporation.
}
\details{
This function will extract relevant information regarding a potential candidate mz-pair (for enrichment) from raw data files.
}
\keyword{internal}
