% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/HighDimOut.R
\name{Func.SNN}
\alias{Func.SNN}
\title{A function to calculate the shared nearest neighbors (SNN)}
\usage{
Func.SNN(data, k.nn, k.sel)
}
\arguments{
\item{data}{is the data frame containing the observations (should be numeric data). Each row represents an observation and each variable is stored in one column.}

\item{k.nn}{specifies the value used for calculating the shared nearest neighbors.}

\item{k.sel}{specifies the number of shared nearest neighbors}
}
\value{
The function returns the matrix containing the indices of top k shared nearest neighbors for each observation
}
\description{
This function calculate the shared nearest neighbors (SNN).
SNN is reported to be more robust than k nearest neighbors.
Firstly, the k nearest neighbor distances for each observation is calculated.
Then, the shared nearest neighbor similarity is calculated based on the result of k nearest neighbor.
Note that k.nn should be greater than k.sel.
}
\examples{
Func.SNN(data=TestData[,1:2], k.nn=5, k.sel=3)
}

