% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/All_classes.R, R/Met_distributionH.R
\docType{class}
\name{distributionH-class}
\alias{distributionH}
\alias{distributionH-class}
\alias{initialize,distributionH-method}
\title{Class distributionH.}
\usage{
\S4method{initialize}{distributionH}(.Object, x = numeric(0),
  p = numeric(0), m = numeric(0), s = numeric(0))

distributionH(x = numeric(0), p = numeric(0))
}
\arguments{
\item{.Object}{the type ("distributionH")}

\item{x}{a numeric vector. it is the domain of the distribution (i.e. the
extremes of bins).}

\item{p}{a numeric vector (of the same lenght of x). It is the cumulative distribution function CDF.}

\item{m}{(optional) a numeric value. Is the mean of the histogram.}

\item{s}{(optional) a numeric positive value. It is the standard deviation of a histogram.}
}
\value{
A \code{distributionH} object
}
\description{
Class distributionH.

Class \code{"distributionH"} desfines an histogram object
The class describes a histogram by means of its cumulative distribution
function. The methods are develoved accordingly to the L2 Wasserstein
distance between distributions.

A histogram object can be created also with the function \code{distributionH(...)}, the costructor function for creating an object containing the description of
a histogram.
}
\details{
Class \code{distributionH} defines a histogram object
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("distributionH", x, p, m, s)}.
}
\examples{
#---- initialize a distributionH object mydist
# from a simple histogram
# ----------------------------
# | Bins    |  Prob  | cdf   |
# ----------------------------
# | [1,2)   |  0.4   | 0.4   |
# | [2,3]   |  0.6   | 1.0   |
# ----------------------------
# | Tot.    |  1.0   | -     |
# ----------------------------
mydist=new("distributionH",c(1,2,3),c(0, 0.4, 1))
str(mydist)
# OUTPUT
# Formal class 'distributionH' [package "HistDAWass"] with 4 slots
#   ..@ x: num [1:3] 1 2 3 the quantiles
#   ..@ p: num [1:3] 0 0.4 1 the cdf
#   ..@ m: num 2.1 the mean
#   ..@ s: num 0.569 the standard deviation
# or using
mydist=distributionH(x=c(1,2,3),p=c(0,0.4, 1))
}
\author{
Antonio Irpino
}
\references{
Irpino, A., Verde, R. (2015) \emph{Basic
statistics for distributional symbolic variables: a new metric-based
approach} Advances in Data Analysis and Classification, DOI
10.1007/s11634-014-0176-4
}
\seealso{
\code{\link{meanH}} computes the mean. \code{\link{stdH}} computes the standard deviation.
}
\keyword{classes}

