% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_MatH.R
\docType{methods}
\name{WH.correlation}
\alias{WH.correlation}
\alias{WH.correlation,MatH-method}
\title{Method WH.correlation}
\usage{
WH.correlation(object, ...)

\S4method{WH.correlation}{MatH}(object, w = numeric(0))
}
\arguments{
\item{object}{a \code{MatH} object}

\item{...}{some optional parameters}

\item{w}{it is possible to add a vector of weights (positive numbers) 
having the same size of the rows of the \code{MatH object}, 
default = equal weight for each row}
}
\value{
a squared \code{matrix} with the (weighted) correlations indices
}
\description{
Method WH.correlation

Compute the correlation matrix of a \code{MatH} object, i.e. 
a matrix of values consistent with 
a set of distributions equipped with a L2 wasserstein metric.
}
\examples{
WH.correlation(BLOOD)
# generate a set of random weights
RN<-runif(get.MatH.nrows(BLOOD))
WH.correlation(BLOOD,w=RN)
}
\references{
Irpino, A., Verde, R. (2015) \emph{Basic
statistics for distributional symbolic variables: a new metric-based
approach} Advances in Data Analysis and Classification, DOI
10.1007/s11634-014-0176-4
}

