% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/writeJagsModel.R
\name{writeJagsModel}
\alias{writeJagsModel}
\title{Write a Node's JAGS Model}
\usage{
writeJagsModel(network, node)
}
\arguments{
\item{network}{A network of class HydeNetwork}

\item{node}{A node within \code{network}}
}
\description{
Constructs the JAGS code that designates the model for the
  node conditioned on its parents.  The parameters for the model may
  be user supplied or estimated from a given data set.
}
\details{
The manipulations are performed on the \code{nodeParams} element
  of the \code{Hyde} network.  A string of JAGS code is returned suitable
  for inclusion in the Bayesian analysis.

  The function will (eventually) travel through a serious of \code{if}
  statements until it finds the right node type.  It will then match
  the appropriate arguments to the inputs based on user supplied values or
  estimating them from the data.
}
\examples{
#* NOTE: writeJagsModel isn't an exported function
data(PE, package='HydeNet')
Net <- HydeNetwork(~ wells +
                     pe | wells +
                     d.dimer | pregnant*pe +
                     angio | pe +
                     treat | d.dimer*angio +
                     death | pe*treat,
                     data = PE)
HydeNet:::writeJagsModel(Net, 'pe')
HydeNet:::writeJagsModel(Net, 'treat')
}
\author{
Jarrod Dalton and Benjamin Nutter
}
\seealso{
\code{\link{writeJagsFormula}}
}

