% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooOth.R
\name{DTh}
\alias{DTh}
\title{Density, Function of Temperature and Enthalpy}
\usage{
DTh(T, h)
}
\arguments{
\item{T}{Temperature in Kelvin}

\item{h}{Enthaly in [ kJ kg-1 ]}
}
\value{
The Density 1: Density_1 [ kg m-3 ]

The Density 2: Density_2 [ kg m-3 ]

Error Message (if an error occur: \link{errorCodes})
}
\description{
The function \code{DTh(T,h)} returns the water density, D [ kg m-3 ],
     for given T [K] and h [ kJ kg-1 ] (it may have two solutions for Density).
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T <- 500.
h <- 977.181624
DTh(T,h)

}

