% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatTable.R
\name{satTabvT}
\alias{satTabvT}
\title{Table of Saturation Volumes, Enthalpies and Entropies, Function of of Temperature}
\usage{
satTabvT(T1, T2, dT)
}
\arguments{
\item{T1}{First Temperature value [K]}

\item{T2}{Final Temperature [K]}

\item{dT}{Temperature increment [K]}
}
\value{
A table of saturation v, h and s, function of T
}
\description{
The function \code{satTabvT(T1, T2, dT)} returns a table of 
    threee saturation properties for two phases: Specific Volume [ m3 kg-1 ], 
    Enthalpy [kJ kg-1] and Entropy [kJ kg K-1] for a Temperature interval, T1:T2 [K].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
T1 <- 275.
T2 <- 450.
dT <- 5.
TabT <- satTabvT(T1, T2, dT)
TabT

T1 <- 300.
T2 <- 500.
dT <- 10.
TabT <- satTabvT(T1, T2, dT)
TabT

}
