% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IATScore.R
\name{IATScore}
\alias{IATScore}
\title{Package to score Implicit Association Test (IAT) output}
\usage{
IATScore(IAT, Trials, First)
}
\arguments{
\item{IAT}{The name of the dataset to be analyzed.}

\item{Trials}{The number of trials across your entire IAT. The default is set to 219, which is typical of most IATs.}

\item{First}{Whether participants first sorted Congruent or Incongruent trials. The default is set to Congruent.}
}
\description{
This minimalist package developed by Daniel Storage is designed to quickly score raw data outputted from an Implicit Association Test (IAT; Greenwald, McGhee, & Schwartz, 1998). IAT scores are calculated as specified by Greenwald, Nosek, and Banaji (2003). Outputted values can be interpreted as effect sizes. Refer to the DESCRIPTION file for more detailed help information (or contact me at sabbystorage@gmail.com).
}
\examples{
IATScore(IAT)
IATScore(IAT, Trials=219)
IATScore(TooFastIAT, Trials=219)
IATScore(BriefIAT, Trials=139)
IATScore(IAT, Trials=219, First="Congruent")
IATScore(IAT, Trials=219, First="Incongruent")
}
\keyword{IAT}
