\name{IBDsim}
\alias{IBDsim}

\title{
IBD simulation
}
\description{
This is the main function of the package. Gene dropping of chromosomes is simulated throughout the pedigree (possibly conditional on the 'condition' pattern), and regions showing the 'query' pattern are collected and summarized.
}
\usage{
IBDsim(x, sims, query=NULL, condition=NULL, map="decode", chromosomes=1:22, model="chi", merged=TRUE, simdata=NULL, skip.recomb = NULL)}
\arguments{
  \item{x}{
a pedigree in the form of a \code{\link{linkdat}} object.
 }
  \item{sims}{
the number of simulations
}
  \item{query, condition}{
single allele patterns, described as lists with numerical entries named '0', '1', '2', 'atleast1', 'atmost1'.
}
  \item{map}{
the genetic map(s) to be used in the simulations: One of the character strings "decode", "uniform.sex.spec", "uniform.sex.aver".
}
  \item{chromosomes}{
a numeric indicating chromosome numbers. The default is to include the complete autosome.
}
  \item{model}{
a character indicating the statistical model for recombination - either "haldane" or "chi".
}
  \item{merged}{
a logical, indicating if overlapping/adjacent regions should be merged or not.
}
  \item{simdata}{
either NULL, in which case the sequence data for all pedigree members will be simulated, or a list of sequence data (usually generated by a previous run of \code{IBDsim}). 
}
  \item{skip.recomb}{
NULL, or a numeric containing individuals whose meioses are to be simulated without recombination (i.e. a random, complete strand is passed on).
}
}
\details{
In each simulation, distinctive alleles are distributed to the pedigree founders, and in  each meiosis homologue chromosomes recombine according to a renewal
process along a four-strand bundle, with chi square distributed waiting times. For comparison purposes, Haldane's Poisson model for recombination is also
implemented. Recombination rates are sex-dependent, and vary along each chromosome according to the recombination map specified by the \code{map} parameter. By default, the complete Decode map of the human autosome is used (see References). If \code{map="uniform.sex.spec"}, the same chromosome lengths as in the Decode map are used, but with constant recombination rates along each chromosome. If \code{map="uniform.sex.spec"}, sex averaged chromosome lengths are used (and constant recombination rates).

IBD patterns are described as combinations of Single Allele Patterns (SAPs). A SAP is a specification for a given allele of the number of copies carried by various individuals. Each SAP should be a list of numerical vectors (containing ID labels), with names '0', '1', '2', 'atleast1', 'atmost1' (some of these can be absent or NULL). See Examples.
}
\value{
If the \code{query} is NULL, the simulated chromosomes are invisibly returned. If \code{query} is non-null, a list of two elements is returned. These are the 'simdata' (the simulated chromosomes) and 'segments' (a list of matrices describing the identified regions).

If \code{query} is non-null, a summary of the regions is printed. The summary has some or all of the following entries: 
'count.all' (the average count of all IBD segments (i.e. counting both random regions and the disease region in case of conditional simulation)),
'fraction.all' (the average fraction of the chromosomes covered by IBD segments),
'average.all' (the average length (in Mb) of IBD segments)
'count.rand' (the average count of random IBD segments),
'fraction.rand' (the average fraction of the chromosomes covered by random IBD segments),
'average.rand' (the average length (in Mb) of random IBD segments),
'dis.length' (the average length of the disease segment (only with conditional simulation)),
'dis.rank' (the average rank of the disease segment length among all the segments),
'zero.segments' (the fraction of simulations resulting in zero IBD segments).
}
\references{
The Decode map:
}
\author{
Magnus Dehli Vigeland
}

\examples{
#Unconditional simulation of regions shared IBD by third cousins.
#The "zero.segments" entry in the output shows the estimated probability of no IBD-sharing among the two cousins (increase 'sims' for more accurate results).
x_male = cousinPed(3)
plot(x_male)
IBDsim(x_male, sims=10, query=list('1'=15:16))

#Changing the genders of the individuals connecting the cousins have a big impact on the distribution of IBD segments:
x_female = swapSex(x_male, c(3,4,7,8,11,12))
IBDsim(x_female, sims=10, query=list('1'=15:16))

#Given that the two third cousins have at least one segment in common, what is the expected length of this segment?
#We simulate conditional on one allele in common between the cousins. The "dis.length" entry of the summary shows the average length of the "forced" region.
#It should be quite a lot larger than an average random segment.
IBDsim(x_male, sims=10, condition=list('1'=15:16), query=list('1'=15:16))

#An example with a recessive disease in a consanguineous pedigree:
data(twoloops)
y = linkdat(twoloops)
plot(y)

#If individuals 15, 16 and 17 are available for sequencing, we can predict the number and size of disease-compatible IBD segments as follows:
IBDsim(y, sims=10, condition=list('2'=15:16, 'atmost1'=17), query=list('2'=15:16, 'atmost1'=17))

#If 16 is unavailable, his parents and healthy sib are still informative. 
#The regions we are looking for now are those with an allele present in 2 copies in 15, 1 copy in 12 and 14, and at most one in 17:
IBDsim(y, sims=10, condition=list('2'=15:16, 'atmost1'=17), query=list('2'=15, '1'=c(12,14), 'atmost1'=17))
}
\keyword{ math }
