% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadVCF}
\alias{ReadVCF}
\title{Read in the data lines of a Variant Call Format (VCF) file}
\usage{
ReadVCF(
  file,
  variant.caller = "unknown",
  name.of.VCF = NULL,
  tumor.col.name = NA,
  filter.status = NULL,
  get.vaf.function = NULL,
  ...
)
}
\arguments{
\item{file}{The name/path of the VCF file, or a complete URL.}

\item{variant.caller}{Name of the variant caller that produces the VCF, can
be either \code{"strelka"}, \code{"mutect"}, \code{"freebayes"} or
\code{"unknown"}. This information is needed to calculate the VAFs (variant
allele frequencies). If \code{"unknown"}(default) and
\code{get.vaf.function} is NULL, then VAF and read depth will be NAs.}

\item{name.of.VCF}{Name of the VCF file. If \code{NULL}(default), this
function will remove all of the path up to and including the last path
separator (if any) in \code{file} and file path without extensions (and the
leading dot) will be used as the name of the VCF file.}

\item{tumor.col.name}{Optional. Only applicable to \strong{Mutect} VCF. Name
of the column in \strong{Mutect} VCF which contains the tumor sample
information. It \strong{must} have quotation marks. If
\code{tumor.col.name} is equal to \code{NA}(default), this function will
use the 10th column to calculate VAFs. See \code{\link{GetMutectVAF}} for
more details.}

\item{filter.status}{The status indicating a variant has passed all filters.
An example would be \code{"PASS"}. Variants which don't have the specified
\code{filter.status} in the \code{FILTER} column in VCF will be removed. If
\code{NULL}(default), no variants will be removed from the original VCF.}

\item{get.vaf.function}{Optional. Only applicable when \code{variant.caller} is
\strong{"unknown"}. Function to calculate VAF(variant allele frequency) and read
  depth information from original VCF. See \code{\link{GetMutectVAF}} as an example.
  If \code{NULL}(default) and \code{variant.caller} is "unknown", then VAF
  and read depth will be NAs.}

\item{...}{Optional arguments to \code{get.vaf.function}.}

\item{num.of.cores}{The number of cores to use. Not available on Windows
unless \code{num.of.cores = 1}.}
}
\value{
A data frame storing data lines of the VCF file with two additional
  columns added which contain the VAF(variant allele frequency) and read
  depth information.
}
\description{
Read in the data lines of a Variant Call Format (VCF) file
}
\keyword{internal}
