% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_mixed_inhibition}
\alias{FIM_mixed_inhibition}
\title{@title Fisher Information Matrix for the Mixed Inhibition Model.}
\usage{
FIM_mixed_inhibition(S, I, w, param)
}
\arguments{
\item{S}{Vector of \code{S} component of design points. \code{S} is the substrate concentration.}

\item{I}{Vector of \code{I} component of design points. \code{I} is the inhibitor concentration.}

\item{w}{Vector of design weight. Its length must be equal to the length of \code{S} and \code{I}, besides  \code{sum(w) = 1}.}

\item{param}{Vector of values for the model parameters \code{c(V, Km, Kic, Kiu)}.}
}
\value{
Fisher information matrix of design.
}
\description{
It provides the cpp function for FIM for the model \code{~ V*S/(Km * (1 + I/Kic)+ S * (1 + I/Kiu))}
}
\details{
The optimal design does not depend on parameter \eqn{V}.
}
\examples{
FIM_mixed_inhibition(S = c(30, 3.86, 30, 4.60),
                     I = c(0, 0, 5.11, 4.16), w = rep(.25, 4),
                     param = c(1.5, 5.2, 3.4, 5.6))
}
\references{
Bogacka, B., Patan, M., Johnson, P. J., Youdim, K., & Atkinson, A. C. (2011). Optimum design of experiments for enzyme inhibition kinetic models. Journal of biopharmaceutical statistics, 21(3), 555-572.
}
