% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{seed_disperse}
\alias{seed_disperse}
\title{Seed-disperser web (1988)}
\format{A data frame with 3 columns and 211 rows:
\describe{
  \item{Bird}{common name of bird speces}
  \item{Plant}{common name of plant species}
  \item{Visits}{number of times the bird species was observed to
  interact with the plant species}
}}
\source{
\url{https://www.nceas.ucsb.edu/interactionweb/html/snow_snow_1988.htm}
}
\usage{
seed_disperse
}
\description{
A bipartite network of bird and plant interactions. Data was recorded
by counting number of visits of each bird species to each plant species.
The original data format (interaction frequency matrix) has been
converted to an edgelist of interaction counts.
}
\details{
Of note, pairs with zero interactions have been omitted. As a result, a
small subset of birds and plants that were in the original matrix are
not present in this dataset (i.e. birds that did not interact with any
plants and vice versa). Additionally, only the common names of the bird
and plant species are included. For the scientific names (genus and
species), please see the original data source (link below).

Citation:
Snow BK, Snow DW (1988). Birds and Berries. Calton, England.
}
\keyword{datasets}
