% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcWeibullCalibP.R
\name{CalcWeibullCalibP}
\alias{CalcWeibullCalibP}
\title{Calculating the probabilities of positive binary exposure status at a given time point using a Weibull calibration model}
\usage{
CalcWeibullCalibP(w, w.res, point, weib.params)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. Each measurement corresponds to the time points in \code{w}}

\item{point}{The time point at which the probabilities are estimated.}

\item{weib.params}{A bivariate vector. Shape and scale parameters of the Weibull calibration model.}
}
\value{
A vector of estimated probabilities of positive exposure status at time \code{point}.
}
\description{
For a given time point, calculate the probability of positive exposure value  for multiple observations (participants). 
The function uses the results of a Weibull calibration model fit, and given collected data on the history 
of the binary exposure for each participant.
}
\examples{
# Simulate data set
sim.data <- ICcalib:::SimCoxIntervalCensSingle(n.sample = 200, lambda = 0.1, 
                                               alpha = 0.25, beta0 = log(0.5), 
                                               mu = 0.2, n.points = 2, 
                                               weib.shape = 1, weib.scale = 2)
# Fit a Weibull calibration model for the covariate starting time distribution
calib.weib.params <- FitCalibWeibull(w = sim.data$w, w.res = sim.data$w.res)
# Calculate the conditional probabilities of binary covariate=1 at time one
probs <- CalcWeibullCalibP(w = sim.data$w, w.res = sim.data$w.res, point = 1,
                           weib.params = calib.weib.params)
summary(probs)
}
\seealso{
\code{\link[stats]{Weibull}}
}
