% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbrier_IC.R
\name{sbrier_IC}
\alias{sbrier_IC}
\title{Model Fit For Interval-Censored Data}
\usage{
sbrier_IC(obj, pred, btime = range(as.numeric(obj[, 1:2])),
  type = c("IBS", "BS"))
}
\arguments{
\item{obj}{an object of class \code{\link[survival]{Surv}}.}

\item{pred}{predicted values. This can be a matrix of survival probabilities evaluated
at a sequence of time points for a set of new data, a list of \code{\link[survival]{survfit}}
objects, a list \code{\link[icenReg]{ic_np}}
objects, or a list of \code{\link[icenReg]{ic_sp}} objects.}

\item{btime}{a vector of length two indicating the range of times that the scores are computed on.
The default \code{btime} is set to be the vector of the smallest and the largest values among
all left and right endpoints given in \code{obj}.}

\item{type}{a character string denoting the type of scores returned. For \code{"IBS"},
the integrated Brier score over the \code{btime} is returned. For \code{"BS"}, the
Brier score at every left and right endpoint of all censoring intervals that lie within
\code{btime} is returned.}
}
\value{
If \code{type = "IBS"}, this returns the integrated Brier score.

If \code{type = "BS"}, this returns the Brier scores.
}
\description{
Compute the (integrated) Brier score to evaluate the model fit for interval-censored survival data.
}
\examples{
### Example with dataset miceData
library(survival)
library(icenReg)
data(miceData)

## For proper evaluation, Inf should be set to be a large number, for example, 9999999.
idx_inf <- (miceData$u == Inf)
miceData$u[idx_inf] <- 9999999.

obj <- Surv(miceData$l, miceData$u, type = "interval2")

## Model fit for an NPMLE survival curve with survfit
pred <- survival::survfit(formula = Surv(l, u, type = "interval2") ~ 1, data = miceData)
# Integrated Brier score up to time = 642
sbrier_IC(obj, pred, btime = c(0, 642), type = "IBS")

## Model fit for a semi-parametric model with icenReg::ic_sp()
pred <- icenReg::ic_sp(formula = Surv(l, u, type = "interval2") ~ 1, data = miceData)
# Integrated Brier score up to the largest endpoints of all censoring intervals in the dataset
sbrier_IC(obj, pred, type = "IBS")

## Model fit for an NPMLE survival curve with icenReg::ic_np()
pred <- icenReg::ic_np(miceData[,c('l', 'u')])
# Brier score computed at every left and right endpoints of all censoring intervals in the dataset
sbrier_IC(obj, pred, type = "BS")



}
\references{
S. Tsouprou. Measures of discrimination and predictive accuracy for interval-censored
data. Master thesis, Leiden University. https://www.math.leidenuniv.nl/scripties/MasterTsouprou.pdf.
}
\keyword{Brier}
\keyword{integrated}
\keyword{score}
\keyword{score,}
