% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetRowCol.R
\name{GetRowCol}
\alias{GetRowCol}
\title{Retrieve matrix row and column indices}
\usage{
GetRowCol(Index, dim1, dim2)
}
\arguments{
\item{Index}{an integer vector index}

\item{dim1}{integer row dimension of the matrix from which the row and column
indices are to be extracted}

\item{dim2}{integer column dimension of the matrix from which the row and
column indices are to be extracted}
}
\value{
a numeric vector of length two with two integers indicating row and
column respectively
}
\description{
Here is a function that will find the row and column indices of a matrix that
are associated with a vector index.
}
\details{
Often when applying functions like the R function which.max(matrix) to a
matrix, a vector index is returned when the coder would prefer to have a row
and column indices. This function converts the vector index to row and column
indices.

The function assumes that the elements of the matrix are filled by column
(byrow = FALSE), which is the default R matrix behaviour.
}
\examples{
GetRowCol(6, dim1 = 3, dim2 = 3) # should return c(3, 2)
}
