% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DispMoransI.R, R/DispStats.R
\name{DispMoransI}
\alias{DispMoransI}
\alias{DispStats}
\title{Calculate statistics in source or sink regions}
\usage{
DispMoransI(inputrast1, inputrast2, statrast, vfdf, sourceloc = TRUE, rad1)

DispStats(
  inputrast1,
  inputrast2,
  statrast,
  vfdf,
  sourceloc = TRUE,
  statistic = "var"
)
}
\arguments{
\item{inputrast1}{a raster as produced by terra::rast}

\item{inputrast2}{a raster of equivalent dimension to inputrast1 as produced
by terra::rast}

\item{statrast}{a raster of equivalent dimension to inputrast1 as produced by
terra::rast which contains the variable that will be used to compute
statistics}

\item{vfdf}{a data frame returned by the \code{\link{DispField}} or
\code{\link{DispFieldbb}} functions, which contains all of the information
necessary for defining regions of interest as well as the displacement
estimates}

\item{sourceloc}{logical (TRUE or FALSE) indicating whether statistics are to be
returned at source or sink locations}

\item{rad1}{an ingeger indicating the neighbourhood radius for Moran's I
statistic calculations in rows/columns. Any cell within a distance of rad1
cells of the focal cell is considered to be in its neighbourhood.}

\item{statistic}{desired output statistic: It should be one of "mean", "var",
or "sum". Default setting is var.}
}
\value{
A data frame is returned with all of the same columns as the vfdf
input data frame plus an additional column containing the computed
statistic in each region of interest defined in vfdf.
}
\description{
Functions for computing the statistics which may be driving variables of
movement that has been quantified using the \code{\link{DispField}} or
\code{\link{DispFieldbb}} functions. The same raster data as were supplied to
the aforementioned functions must be supplied to these in addition to a
raster layer for which statistics are sought. Then for each region of
interest defined when \code{\link{DispField}} or \code{\link{DispFieldbb}}
were called, these functions compute statistics for presumed source (sourceloc =
TRUE) locations or presumed sink locations (sourceloc = FALSE). Note that in the
DispMornasI function, defining radius using distance means that a radius of
one corresponds to the rook's neighbourhood.
}
\examples{
# Illustrating use of DispMoransI:

(Mat1 <- matrix(c(0.1,1,0.1,0,0,0,0,0,0,
                  1,0.1,1,0,0,0,0,0,0,
                  0.1,1,0.1,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0),
                 nrow = 9))
(Mat2 <- matrix(c(0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0.1,1,0.1,0,0,0,0,0,0,
                  1,0.1,1,0,0,0,0,0,0,
                  0.1,1,0.1,0,0,0,0,0,0),
                 nrow = 9))

# Note that rasterizing a matrix causes it to be rotated 90 degrees.
# Therefore, any shift in the x direction is in fact now a shift in the y direction
rast1 <- terra::rast(Mat1)
terra::plot(rast1)
rast2 <- terra::rast(Mat2)
terra::plot(rast2)

(VFdf1 <- DispField(rast1, rast2, factv1 = 3, facth1 = 3))
# The second raster is shifted down by -0.6666667 units relative to the first raster
# dispy = -0.6666667 (the width of each box is 0.1111111).

# Now to compute the statistics at the source: the Moran's I of the original values
# in each region of interest (should be minus one in first row)
(VFdf2 <- DispMoransI(rast1, rast2, rast1, VFdf1, sourceloc = TRUE, rad1 = 1))

# Illustrating use of DispStats:

(Mat1 <- matrix(c(1,1,1,0,0,0,0,0,0,
                  1,1,1,0,0,0,0,0,0,
                  1,1,1,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0),
                 nrow = 9))
(Mat2 <- matrix(c(0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  0,0,0,0,0,0,0,0,0,
                  1,1,1,0,0,0,0,0,0,
                  1,1,1,0,0,0,0,0,0,
                  1,1,1,0,0,0,0,0,0),
                 nrow = 9))

# Note that rasterizing a matrix causes it to be rotated 90 degrees.
# Therefore, any shift in the x direction is in fact now a shift in the y direction
rast1 <- terra::rast(Mat1)
terra::plot(rast1)
rast2 <- terra::rast(Mat2)
terra::plot(rast2)

(VFdf1 <- DispField(rast1, rast2, factv1 = 3, facth1 = 3))
# The second raster is shifted down by -0.6666667 units relative to the first raster
# dispy = -0.6666667 (the width of each box is 0.1111111).

# Now to compute the statistics at the source: the mean of the original values
# in each region of interest (should be one in first row)
(VFdf2 <- DispStats(rast1, rast2, rast1, VFdf1, sourceloc = TRUE, statistic = "mean"))
# sum in each region of interest (should be nine in first row)
(VFdf3 <- DispStats(rast1, rast2, rast1, VFdf1, sourceloc = TRUE, statistic = "sum"))
# variance in each region of interest (should be zero in all rows)
(VFdf4 <- DispStats(rast1, rast2, rast1, VFdf1, sourceloc = TRUE, statistic = "var"))
}
