% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_gdc_uuid.R
\name{parse_gdc_file_uuid}
\alias{parse_gdc_file_uuid}
\title{Parse Sample ID from GDC Portal File UUID}
\usage{
parse_gdc_file_uuid(
  x,
  legacy = FALSE,
  fields = "cases.samples.submitter_id,cases.samples.sample_type,file_id",
  token = NULL,
  max_try = 5L
)
}
\arguments{
\item{x}{a GDC manifest file or a vector of file UUIDs.}

\item{legacy}{if use GDC legacy data.}

\item{fields}{a list of fields to query.
If it is a string, then fields should be separated by comma.
It could also be a vector.
See \url{https://docs.gdc.cancer.gov/API/Users_Guide/Appendix_A_Available_Fields/#file-fields}
for list.}

\item{token}{the token used for querying.}

\item{max_try}{maximum try time.}
}
\value{
a \code{data.frame}
}
\description{
Parse Sample ID from GDC Portal File UUID
}
\examples{

parse_gdc_file_uuid("fe522fc8-e690-49b9-b3b6-fa3658705057")
parse_gdc_file_uuid(
  c(
    "fe522fc8-e690-49b9-b3b6-fa3658705057",
    "2c16506f-1110-4d60-81e3-a85233c79909"
  )
)
}
