IDSL.CSA_workflow <- function(spreadsheet) {
  ##
  tryCatch(stop(""), error = function(e){""}) # To clear cache of error messages
  on.exit({
    sillyErrors <- c("",
                     "subscript out of bounds",
                     "StopIteration", # StopIteration is generated by `foreach`
                     "cannot shut down device 1 (the null device)") # error by `dev.off()`
    ##
    errorMessages <- geterrmessage()
    xSillyErrors <- which(!(errorMessages %in% sillyErrors))
    if (length(xSillyErrors) > 0) {
      FSA_logRecorder(errorMessages[xSillyErrors])
      FSA_logRecorder("Stopped IDSL.CSA workflow!")
    }
    ##
    if (exists('.logFSA')) {
      rm(.logFSA, envir = .GlobalEnv)
    }
  })
  ##
  gc()
  closeAllConnections()
  ##############################################################################
  PARAM_total <- IDSL.CSA_xlsxAnalyzer(spreadsheet)
  PARAM_Start <- PARAM_total[["PARAM_Start"]]
  PARAM_FSdb <- PARAM_total[["PARAM_FSdb"]]
  ##
  if (!is.null(PARAM_Start)) {
    CSA <- tolower(PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0001'), 2])
    DDA <- tolower(PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0002'), 2])
    DIA <- tolower(PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0003'), 2])
    ##
    if (CSA == "yes") {
      PARAM_CSA <- PARAM_total[["PARAM_CSA"]]
      if (length(PARAM_CSA) > 0) {
        CSA_workflow(PARAM_CSA)
      } else {
        stop()
      }
      ##
    } else if (DDA == "yes") {
      PARAM_DDA <- PARAM_total[["PARAM_DDA"]]
      if (length(PARAM_DDA) > 0) {
        DDA_workflow(PARAM_DDA)
      } else {
        stop()
      }
      ##
    } else if (DIA == "yes") {
      ##
      PARAM_DIA <- PARAM_total[["PARAM_DIA"]]
      if (length(PARAM_DIA) > 0) {
        DIA_workflow(PARAM_DIA)
      } else {
        stop()
      }
    }
    ############################################################################
    PARAM0004 <- tolower(PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0004'), 2])
    PARAM0005 <- tolower(PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0005'), 2])
    PARAM0006 <- tolower(PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0006'), 2])
    ############################################################################
    if ((PARAM0005 == "yes") | PARAM0006 == "yes") {
      output_path <- PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0009'), 2]
      ##
      IDSL.IPA::opendir(output_path)
    } else {
      output_path <- NULL
    }
    ##
    ############################################################################
    ##
    if (PARAM0005 == "yes") {
      .logFSA <- NULL
      .logFSA <<- paste0(output_path, "/logFSA_msp_annotation.txt")
      FSA_logRecorder(paste0(rep("", 100), collapse = "="))
    }
    ##
    if (PARAM0004 == "yes") {
      ##
      libFSdb <- FSdb_file_generator(PARAM_FSdb, output_path)
      ##
      if (PARAM0005 == "yes") {
        address_FSDB <- PARAM_FSdb[which(PARAM_FSdb[, 1] == "FSdb0003"), 2]
        exportFSdbCheck <- if (tolower(address_FSDB) == "na") {FALSE} else {TRUE}
        if (exportFSdbCheck) {
          name_FSDB <- PARAM_FSdb[which(PARAM_FSdb[, 1] == "FSdb0004"), 2]
          FSdb_file <- paste0(address_FSDB, "/", name_FSDB, ".Rdata")
          FSdb_file <- gsub("\\", "/", FSdb_file, fixed = TRUE)
          ##
          FSA_logRecorder(paste0("The Fragmentation Spectra DataBase (FSDB) library is used from `", FSdb_file, "`!"))
        } else {
          FSA_logRecorder("The generated Fragmentation Spectra DataBase (FSDB) library is used for annotation!")
        }
      }
      ##
    } else if (PARAM0004 == "no") {
      ##
      if (PARAM0005 == "yes") {
        FSdb_file <- PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0007'), 2]
        FSA_logRecorder(paste0("Loading the Fragmentation Spectra DataBase (FSDB) library from `", FSdb_file, "`!"))
        libFSdb <- IDSL.IPA::loadRdata(FSdb_file)
      }
    }
    ############################################################################
    if (PARAM0005 == "yes") {
      address_input_msp <- PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0008'), 2]
      PARAM_SPEC <- PARAM_total[["PARAM_SPEC"]]
      ##
      FSA_msp_annotator(PARAM_SPEC, libFSdb, address_input_msp, output_path)
    }
    ############################################################################
    if (PARAM0006 == "yes") {
      PARAM_AT <- PARAM_total[["PARAM_AT"]]
      aligned_fragmentation_spectra_annotator(PARAM_AT, output_path)
    }
    ############################################################################
    gc()
    closeAllConnections()
    ##
  }
}