FSA_workflow <- function(spreadsheet) {
  ##
  tryCatch(stop(""), error = function(e){""}) # To clear cache of error messages
  on.exit({
    sillyErrors <- c("",
                     "subscript out of bounds",
                     "StopIteration", # StopIteration is generated by `foreach`
                     "cannot shut down device 1 (the null device)") # error by `dev.off()`
    ##
    errorMessages <- geterrmessage()
    xSillyErrors <- which(!(errorMessages %in% sillyErrors))
    if (length(xSillyErrors) > 0) {
      FSA_logRecorder(errorMessages[xSillyErrors])
      FSA_logRecorder("Stopped IDSL.FSA workflow!")
    }
    ##
    if (exists('.logFSA')) {
      rm(.logFSA, envir = .GlobalEnv)
    }
  })
  ##
  gc()
  closeAllConnections()
  ##############################################################################
  spreadsheet <- gsub("\\", "/", spreadsheet, fixed = TRUE)
  PARAM_total <- FSA_xlsxAnalyzer(spreadsheet)
  PARAM_FSA <- PARAM_total[["PARAM_FSA"]]
  PARAM_FSdb <- PARAM_total[["PARAM_FSdb"]]
  PARAM_SPEC <- PARAM_total[["PARAM_SPEC"]]
  ##
  if (length(PARAM_FSA) > 0) {
    address_input_msp <- PARAM_FSA[which(PARAM_FSA[, 1] == 'FSA0003'), 2]
    output_path <- PARAM_FSA[which(PARAM_FSA[, 1] == 'FSA0004'), 2]
    FSA_opendir(output_path)
    ##
    ############################################################################
    ## To create log record for IDSL.FSA
    initiation_time_FSA <- Sys.time()
    timeZone <- tryCatch(Sys.timezone(), warning = function(w) {"UTC"}, error = function(e) {"UTC"})
    .logFSA <- NULL
    .logFSA <<- paste0(output_path, "/logFSA_performance.txt")
    FSA_logRecorder(paste0(rep("", 100), collapse = "="))
    FSA_logRecorder(paste0("MSP/MGF:  ", address_input_msp))
    FSA_logRecorder(paste0("OUTPUT:  ", output_path))
    FSA_logRecorder(paste0(rep("", 100), collapse = "-"))
    FSA_logRecorder("Initiated the FSA workflow!")
    FSA_logRecorder(paste0(as.character(initiation_time_FSA), " ", timeZone))
    FSA_logRecorder("", allowedPrinting = FALSE)
    FSA_logRecorder("", allowedPrinting = FALSE)
    FSA_logRecorder(paste0(PARAM_FSA[, 1], "\t", PARAM_FSA[, 2]),  allowedPrinting = FALSE)
    FSA_logRecorder(paste0(rep("", 100), collapse = "-"))
    ##
    ############################################################################
    ##
    entireMGFMSP <- dir(path = address_input_msp)
    entireMGF <- entireMGFMSP[grepl(".mgf$", entireMGFMSP, ignore.case = TRUE)]
    ##
    patternMSP <- entireMGFMSP[grepl(".msp$", entireMGFMSP, ignore.case = TRUE)]
    patternMSP2MGF1 <- gsub(".mgf$", "", entireMGF, ignore.case = TRUE)
    patternMSP2MGF2 <- gsub(".msp$", "", patternMSP, ignore.case = TRUE)
    xMSP2MGF <- which(!(patternMSP2MGF1 %in% patternMSP2MGF2))
    entireMGF <- entireMGF[xMSP2MGF]
    ##
    ############################################################################
    ##
    if (length(entireMGF) > 0) {
      FSA_logRecorder("Started converting MGF files into MSP files!")
      ##
      NPT <- as.numeric(PARAM_SPEC[which(PARAM_SPEC[, 1] == "SPEC0002"), 2])
      ##
      if (NPT == 1) {
        iCounter <- 1
        progressBARboundaries <- txtProgressBar(min = 0, max = length(entireMGF), initial = 0, style = 3)
        for (i in entireMGF) {
          null_variable <- tryCatch(mgf2msp(path = address_input_msp, MGFfile = i), error = function(e) {FSA_logRecorder(paste0("Problem with `", i,"`!"))})
          ##
          iCounter <- iCounter + 1
          setTxtProgressBar(progressBARboundaries, iCounter)
        }
        close(progressBARboundaries)
      } else {
        ##
        osType <- Sys.info()[['sysname']]
        ##
        if (osType == "Linux") {
          ##
          null_variable <- mclapply(entireMGF, function(i) {
            tryCatch(mgf2msp(path = address_input_msp, MGFfile = i), error = function(e) {FSA_logRecorder(paste0("Problem with `", i,"`!"))})
          }, mc.cores = NPT)
          ##
          closeAllConnections()
          ##
        } else if (osType == "Windows") {
          ##
          clust <- makeCluster(NPT)
          registerDoParallel(clust)
          ##
          null_variable <- foreach(i = entireMGF, .verbose = FALSE) %dopar% {
            tryCatch(mgf2msp(path = address_input_msp, MGFfile = i), error = function(e) {FSA_logRecorder(paste0("Problem with `", i,"`!"))})
          }
          ##
          stopCluster(clust)
        }
      }
    }
    ############################################################################
    FSA0001 <- tolower(PARAM_FSA[which(PARAM_FSA[, 1] == "FSA0001"), 2])
    ##
    if (FSA0001 == "yes") {
      libFSdb <- FSdb_file_generator(PARAM_FSdb, output_path)
      ##
      logFSA1 <- paste0(output_path, "/logFSA_msp_annotation.txt")
      .logFSA <- NULL
      .logFSA <<- logFSA1
      FSA_logRecorder(paste0(rep("", 100), collapse = "="))
      address_FSDB <- PARAM_FSdb[which(PARAM_FSdb[, 1] == "FSdb0003"), 2]
      exportFSdbCheck <- if (tolower(address_FSDB) == "na") {FALSE} else {TRUE}
      if (exportFSdbCheck) {
        name_FSDB <- PARAM_FSdb[which(PARAM_FSdb[, 1] == "FSdb0004"), 2]
        FSdb_file <- paste0(address_FSDB, "/", name_FSDB, ".Rdata")
        FSdb_file <- gsub("\\", "/", FSdb_file, fixed = TRUE)
        ##
        FSA_logRecorder(paste0("The Fragmentation Spectra DataBase (FSDB) library is used from `", FSdb_file, "`!"))
      } else {
        FSA_logRecorder("The generated Fragmentation Spectra DataBase (FSDB) library is used for annotation!")
      }
      ##
    } else if (FSA0001 == "no") {
      ##
      .logFSA <- NULL
      .logFSA <<- paste0(output_path, "/logFSA_msp_annotation.txt")
      FSA_logRecorder(paste0(rep("", 100), collapse = "="))
      ##
      FSdb_file <- PARAM_FSA[which(PARAM_FSA[, 1] == "FSA0002"), 2]
      FSA_logRecorder(paste0("Loading the Fragmentation Spectra DataBase (FSDB) library from `", FSdb_file, "`!"))
      libFSdb <- FSA_loadRdata(FSdb_file)
    }
    ##
    ############################################################################
    ##
    FSA_msp_annotator(PARAM_SPEC, libFSdb, address_input_msp, output_path)
    ##
    ############################################################################
    ##
    completion_time_FSA <- Sys.time()
    .logFSA <<- logFSA1
    FSA_logRecorder(paste0(rep("", 100), collapse = "-"))
    required_time <- completion_time_FSA - initiation_time_FSA
    FSA_logRecorder(paste0("The required processing time was `", required_time, " ", attributes(required_time)$units, "`"))
    FSA_logRecorder(paste0(as.character(completion_time_FSA), " ", timeZone), allowedPrinting = FALSE)
    FSA_logRecorder("", allowedPrinting = FALSE)
    FSA_logRecorder("", allowedPrinting = FALSE)
    FSA_logRecorder("Completed the FSA workflow!")
    FSA_logRecorder(paste0(rep("", 100), collapse = "="), allowedPrinting = FALSE)
    ##
    ############################################################################
    ##
    gc()
    closeAllConnections()
    ##
  }
}