% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IFAAfunc.R
\name{IFAA}
\alias{IFAA}
\title{Robust association identification and inference for absolute abundance in microbiome analyses}
\usage{
IFAA(
  MicrobData,
  CovData,
  linkIDname,
  testCov = NULL,
  ctrlCov = NULL,
  testMany = TRUE,
  ctrlMany = FALSE,
  nRef = 40,
  nRefMaxForEsti = 2,
  refTaxa = NULL,
  adjust_method = "BY",
  fdrRate = 0.25,
  paraJobs = NULL,
  bootB = 500,
  standardize = FALSE,
  sequentialRun = FALSE,
  refReadsThresh = 0.2,
  taxkeepThresh = 0,
  SDThresh = 0.05,
  SDquantilThresh = 0,
  balanceCut = 0.2,
  seed = 1
)
}
\arguments{
\item{MicrobData}{Microbiome data matrix containing microbiome abundance with each row per
sample and each column per taxon/OTU/ASV. It should contain an \code{"id"} variable to correspond
to the \code{"id"} variable in the covariates data: \code{CovData}. This argument can take
directory path. For example, \code{MicrobData="C://...//microbiomeData.tsv"}.}

\item{CovData}{Covariates data matrix containing covariates and confounders with each row
per sample and each column per variable. It should also contain an \code{"id"} variable to
correspond to the \code{"id"} variable in the microbiome data: \code{MicrobData}. This argument can take
directory path. For example, \code{CovData = "C://...//covariatesData.tsv"}.}

\item{linkIDname}{Variable name of the \code{"id"} variable in both \code{MicrobData} and \code{CovData}. The two data sets will be merged by this \code{"id"} variable.}

\item{testCov}{Covariates that are of primary interest for testing and estimating the associations. It corresponds to $X_i$ in the equation. Default is \code{NULL} which means all covariates are \code{testCov}.}

\item{ctrlCov}{Potential confounders that will be adjusted in the model. It corresponds to $W_i$ in the equation. Default is \code{NULL} which means all covariates except those in \code{testCov} are adjusted as confounders.}

\item{testMany}{This takes logical value \code{TRUE} or \code{FALSE}. If \code{TRUE}, the \code{testCov} will contain all the variables in \code{CovData} provided \code{testCov} is set to be \code{NULL}. The default value is \code{TRUE} which does not do anything if \code{testCov} is not \code{NULL}.}

\item{ctrlMany}{This takes logical value \code{TRUE} or \code{FALSE}. If \code{TRUE}, all variables except \code{testCov} are considered as control covariates provided \code{ctrlCov} is set to be \code{NULL}. The default value is \code{FALSE}.}

\item{nRef}{The number of randomly picked reference taxa used in phase 1. Default number is \code{40}.}

\item{nRefMaxForEsti}{The maximum number of reference taxa used in phase 2. The default is \code{1}.}

\item{refTaxa}{A vector of taxa or OTU or ASV names. These are reference taxa specified by the user to be used in phase 1. If the number of reference taxa is less than 'nRef', the algorithm will randomly pick extra reference taxa to make up 'nRef'. The default is \code{NULL} since the algorithm will pick reference taxa randomly.}

\item{adjust_method}{The adjusting method used for p value adjustment. Same as p.adjust function in R.}

\item{fdrRate}{The false discovery rate for identifying taxa/OTU/ASV associated with \code{testCov}. Default is \code{0.25}.}

\item{paraJobs}{If \code{sequentialRun} is \code{FALSE}, this specifies the number of parallel jobs that will be registered to run the algorithm. If specified as \code{NULL}, it will automatically detect the cores to decide the number of parallel jobs. Default is \code{NULL}. It is safe to have 4gb memory per job. It may be needed to reduce the number of jobs if memory is limited.}

\item{bootB}{Number of bootstrap samples for obtaining confidence interval of estimates in phase 2. The default is \code{500}.}

\item{standardize}{This takes a logical value \code{TRUE} or \code{FALSE}. If \code{TRUE}, all design matrix X in phase 1 and phase 2 will be standardized in the analyses. Default is \code{FALSE}.}

\item{sequentialRun}{This takes a logical value \code{TRUE} or \code{FALSE}. Default is \code{FALSE}. This argument could be useful for debug.}

\item{refReadsThresh}{The threshold of non-zero sequencing reads for choosing the reference taxon in phase 2. The default is \code{0.2} which means at least 20\% non-zero sequencing reads.}

\item{taxkeepThresh}{The threshold of number of non-zero sequencing reads for each taxon to be included into the analysis.}

\item{SDThresh}{The threshold of standard deviations of sequencing reads for choosing the reference taxon in phase 2. The default is \code{0.5} which means the standard deviation of sequencing reads should be at least \code{0.5}.}

\item{SDquantilThresh}{Threshold for the quantile of standard deviation for selecting final reference taxon}

\item{balanceCut}{The threshold of non-zero sequencing reads in each group of a binary variable for choosing the reference taxon in phase 2. The default number is \code{0.2} which means at least 20\% sequencing reads are non-zero in each group.}

\item{seed}{Random seed for reproducibility. Default is \code{1}.}
}
\value{
A list containing the estimation results.
\itemize{
\item \code{analysisResults$sig_list_each_mean}: A list containing estimating results for all the variables in \code{testCov}. See details.
\item \code{covariatesData}: A dataset containing covariates and confounders used in the analyses.
}
}
\description{
Make inference on the association of covariates of microbiome
}
\details{
To model the association, the following equation is used:

\loadmathjax

\mjdeqn{\log(\mathcal{Y}_i^k)|\mathcal{Y}_i^k>0=\beta^{0k}+X_i^T\beta^k+W_i^T\gamma^k+Z_i^Tb_i+\epsilon_i^k,\hspace{0.2cm}k=1,...,K+1}{}
where
\itemize{
\item \mjeqn{\mathcal{Y}_i^k}{} is the AA of taxa \mjeqn{k}{} in subject \mjeqn{i}{} in the entire ecosystem.
\item \mjeqn{X_i}{} is the covariate matrix.
\item \mjeqn{W_i}{} is the confounder matrix.
\item \mjeqn{Z_i}{} is the design matrix for random effects.
\item \mjeqn{\beta^k}{} is the regression coefficients that will be estimated and tested with the \code{IFAA()} function.
}

The challenge in microbiome analysis is that \mjeqn{\mathcal{Y}_i^k}{} can not be observed. What is observed is its small proportion:
\mjeqn{Y_i^k=C_i\mathcal{Y}^k_i}{}, where \mjeqn{C_i}{} is an unknown number between 0
and 1 that denote the observed proportion.

The IFAA method can handle this challenge by
identifying and employing reference taxa. The \code{IFAA()} will estimate the parameter
\mjeqn{\beta^k}{} and their 95\% confidence intervals. High-dimensional \mjeqn{X_i}{} is handled by
regularization.
}
\examples{
data(dataM)
dim(dataM)
dataM[1:5, 1:8]
data(dataC)
dim(dataC)
dataC[1:5, ]
\donttest{
results <- IFAA(MicrobData = dataM,
                CovData = dataC,
                linkIDname = "id",
                testCov = c("v1", "v2"),
                ctrlCov = c("v3"), nRef = 3,
                paraJobs = 2,
                fdrRate = 0.25,
                bootB = 5)

}



}
\references{
Li et al.(In press) IFAA: Robust association identification and Inference For Absolute Abundance in microbiome analyses. Journal of the American Statistical Association

Zhang CH (2010) Nearly unbiased variable selection under minimax concave penalty. Annals of Statistics. 38(2):894-942.

Freedman and Lane (1983) A non-stochastic interpretation of reported significance levels. Journal of Business & Economic Statistics. 1(4):292-298.
}
