% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOffsets.R
\name{getOffsets}
\alias{getOffsets}
\title{RIF/CIF File Image Field Directories Offsets Extraction}
\source{
TIFF 6.0 specifications archived from web \url{https://web.archive.org/web/20211209104854/https://www.adobe.io/open/standards/TIFF.html}
}
\usage{
getOffsets(fileName, fast = TRUE, display_progress = TRUE, verbose = FALSE)
}
\arguments{
\item{fileName}{path to file.}

\item{fast}{whether to fast extract objects or not. Default is TRUE.\cr
Meaning that offsets will be extracting expecting that objects are stored in ascending order.\cr
A message will be thrown since fast extraction method does not ensure correct mapping between objects and offsets.\cr
If set to FALSE, all object_ids will be scanned from 'fileName' to ensure extraction of desired offsets.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}
}
\value{
an integer vector of class `IFC_offset` of IFDs offsets found in XIF file.
}
\description{
Extracts offsets of the IFDs (Image Field Directories) within a XIF file.
Users are highly encouraged to read TIFF specifications to have a better understanding about what offsets and IFDs are.
}
\details{
Offsets are byte positions of IFDs found within RIF or CIF file. For more details see TIFF specifications.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a cif file
  file_cif <- system.file("extdata", "example.cif", package = "IFCdata")
  system.time(offsets_fast <- getOffsets(fileName = file_cif, fast = TRUE))
  system.time(offsets_slow <- getOffsets(fileName = file_cif, fast = FALSE))
  identical(offsets_fast, offsets_slow)   
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
