% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs_utils.R
\name{get_coordmap_adjusted}
\alias{get_coordmap_adjusted}
\title{Device Adjusted Coordinates}
\source{
computes drawing region in a similar way as shiny:::getPrevPlotCoordmap()
}
\usage{
get_coordmap_adjusted(
  coordmap,
  width = grDevices::dev.size("px")[1],
  height = grDevices::dev.size("px")[2],
  ratio = graphics::par("din")/graphics::par("pin")
)
}
\arguments{
\item{coordmap}{current device plotting region. Default is missing.}

\item{width}{current device height in pixel. Default is grDevices::dev.size("px")[1].}

\item{height}{current device width in pixel. Default is grDevices::dev.size("px")[2].}

\item{ratio}{current device ratio. Default is graphics::par('din') / graphics::par('pin').}
}
\description{
Helper to extract current device plotting region adjusted to device size
}
\keyword{internal}
