% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHawkes.R
\name{simchildren}
\alias{simchildren}
\title{Simulate the child events
\code{simchildren} simulates the birth times of all child events
spawned from an event relative the birth time of the parent
event. This function is to be called by the simulator function for
offspring events and is not meant for external use.}
\usage{
simchildren(br = 0.5, dis = "exp", par.dis = list(rate = 1))
}
\arguments{
\item{br}{numerical scalar in [0,1), the branching ratio, or the
expected number of direct children due to an event}

\item{dis, }{character string, which gives the name of the common
(positive) distribution of the birth times of the child events
relative to the parent event (referred to as the child
birthtime distribution), such as "exp", "gamma", "weibull",
etc.}

\item{par.dis, }{list, which gives the values of the (named)
parameter(s) of the child birthtime distribution)}
}
\value{
a numeric vector of length giving the birth times of child
    events relative to the parent event in ascending order
}
\description{
Simulate the child events
\code{simchildren} simulates the birth times of all child events
spawned from an event relative the birth time of the parent
event. This function is to be called by the simulator function for
offspring events and is not meant for external use.
}
\examples{
  simchildren(br=0.9,dis="exp",par.dis=list(rate=1))
}
\seealso{
\code{\link{simoffspring}}
}
