% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{rDirichlet}
\alias{rDirichlet}
\title{Simulate Mixing Proportions from a Dirichlet Distribution}
\usage{
rDirichlet(G, alpha, nn = 0)
}
\arguments{
\item{G}{The number of groups for which weights need to be sampled.}

\item{alpha}{The Dirichlet hyperparameter, either of length 1 or \code{G}. When the length of \code{alpha} is 1, this amounts to assuming an exchangeable prior. Be warned that this will be recycled if necessary.}

\item{nn}{A vector giving the number of observations in each of G groups so that Dirichlet posteriors rather than priors can be sampled from. This defaults to 0, i.e. simulation from the prior. Be warned that this will be recycled if necessary.}
}
\value{
A Dirichlet vector of \code{G} weights which sum to 1.
}
\description{
Generates samples from the Dirichlet distrubution with parameter \code{alpha} efficiently by simulating Gamma(\code{alpha}, 1) random variables and normalising them.
}
\note{
Though the function is available for standalone use, note that no checks take place, in order to speed up repeated calls to the function inside \code{\link{mcmc_IMIFA}}.
}
\examples{
prior     <- rDirichlet(G=5, alpha=1)
posterior <- rDirichlet(G=5, alpha=1, nn=c(20, 41, 32, 8, 12))
}
\references{
Devroye, L. (1986) \emph{Non-Uniform Random Variate Generation}, Springer-Verlag, New York, p. 594.
}
