% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMIFA.R
\docType{package}
\name{IMIFA-package}
\alias{IMIFA}
\alias{IMIFA-package}
\title{IMIFA: Infinite Mixtures of Infinite Factor Analysers and Related Models}
\description{
A package for Bayesian nonparameteric clustering of high-dimensional datasets, providing functions for fitting, diagnostic tools and plotting for Infinite Mixtures of Infinite Factor Analysers and the full suite of related models. Allows model based clustering with factor analytic covariance structures without recourse to model selection criteria to choose the number of clusters or cluster-specific latent factors. Model-specific diagnostic tools are also provided, as well as many options for plotting results, conducting posterior inference on parameters of interest, posterior predictive checking, and quantifying uncertainty.
}
\section{Details}{

\itemize{
\item{Type: }{Package}
\item{Package: }{IMIFA}
\item{Version: }{2.1.3}
\item{Date: }{2020-05-12 (this version), 2017-02-02 (original release)}
\item{Licence: }{GPL (>=2)}
}
}

\section{Usage}{

The three most important functions in the \pkg{IMIFA} package are: \code{\link{mcmc_IMIFA}}, for fitting the model, \code{\link{get_IMIFA_results}}, for extracting results from objects of the \code{"IMIFA"} class generated by \code{\link{mcmc_IMIFA}}, and the dedicated plotting function \code{\link{plot.Results_IMIFA}}, for plotting results pertaining to parameters of inferential interest from objects of class \code{"Results_IMIFA"} generated by \code{\link{get_IMIFA_results}}.

Other functions also exist, e.g. for simulating data from a multivariate mixture of factor analysers, many functions for soliciting good priors, and many functions related to plotting.

\code{\link{mcmc_IMIFA}}:
This function estimates models in the IMIFA family under the Bayesian paradigm. Most importantly, one must specify the \code{method} in the form of an acronym (e.g. \code{"MIFA"} for Mixtures of Infinite Factor Analysers) and ranges of values for range.G, the number of clusters, and range.Q, the number(s) of (cluster-specific) latent factors as required by said method.

\code{\link{get_IMIFA_results}}:
Raw simulation objects generated by mcmc_IMIFA() are passed to this function in order to extract results of interest and conduct further post-processing if necessary.

\code{\link{plot.Results_IMIFA}}:
Results obtained from get_IMIFA_Results are passed to this function with the type of plot desired specified by \code{plot.meth} (e.g. \code{"trace"}) and the parameter of interest specified by \code{param} (e.g. \code{"loadings"}).
}

\section{References}{

Murphy, K., Viroli, C., and Gormley, I. C. (2019) Infinite mixtures of infinite factor analysers, \emph{Bayesian Analysis}, 1-27. <\href{https://projecteuclid.org/euclid.ba/1570586978}{doi:10.1214/19-BA1179}>.
}

\section{See Also}{

Further details and examples are given in the associated vignette document:\cr
\code{vignette("IMIFA", package = "IMIFA")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://cran.r-project.org/package=IMIFA}
  \item Report bugs at \url{https://github.com/Keefe-Murphy/IMIFA}
}

}
\author{
Keefe Murphy [aut, cre], Cinzia Viroli [ctb], Isobel Claire Gormley [ctb]

\strong{Maintainer}: Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{package}
