% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INCA.SpikePlot.R
\name{INCA.SpikePlot}
\alias{INCA.SpikePlot}
\title{Linearity Plot for Spike In Probes}
\usage{
INCA.SpikePlot(x, SpikeFile, wcol, base = 2)
}
\arguments{
\item{x}{an RGList object}

\item{SpikeFile}{a data.frame specifying the Spike In probe names in a column called "Probe" and the expected relative amounts for each dye, respectively in a "Cy5" and "Cy3" column. For example, a given probe might be expected in a 3:1 ratio thus column "Cy5" would specify 3 and column "Cy3" would specify 1.}

\item{wcol}{an integer specifying the number of the column where Gene Names can be found in the gene annotation table.}

\item{base}{an integer specifying the log base. Default is 2.}
}
\value{
Generates jpeg files of SpikeIn Linearity plots for each arrays.
}
\description{
Plots a linearity plot for Spike In probes for microarray data.
}
\examples{
#Load the INCATome Dataset
data(INCATomeData)
attach(INCATomeData)
INCA.SpikePlot(RGdata,sdata,8)
}
