% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_nrmse.R
\name{calc_nrmse}
\alias{calc_nrmse}
\title{Calculates the Normalized Root Mean Square Error (NRMSE) as absolute value.}
\usage{
calc_nrmse(pred, obs_ind)
}
\arguments{
\item{pred}{A list of vectors with predicted values.}

\item{obs_ind}{A list of vectors with observed values.}
}
\value{
The function returns a numerical vector of the same length then the
input lists, with one NRMSE value for each GAM(M).
}
\description{
\code{calc_nrmse} is a helper function for \code{\link{model_gam}} and
\code{\link{model_gamm}} and calculates the NRMSE from the test data.
The test MSE and test RMSE are commonly used tools for measuring the quality of
the model fit on previously unseen data. The normalization to the mean of
the observed test data allows for comparisons and a general scoring of the
model robustness across INDs with different scales or units. The absolute
values are needed for the \code{\link{scoring}} function.
}
\examples{
# Using the Baltic Sea demo data
data <- dplyr::left_join(model_gam_ex, ind_init_ex)
pred <- calc_pred(data$model, data$press_test)
x <- calc_nrmse(pred = pred$pred, obs_ind = data$ind_test)
}
\seealso{
\code{\link{model_gam}} and \code{\link{model_gamm}}
}
\keyword{internal}
