% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooks_dist_gamm.R
\name{cooks_dist_gamm}
\alias{cooks_dist_gamm}
\title{Calculates the Cook`s distance for Generalized Additive Mixed Models (GAMM)}
\usage{
cooks_dist_gamm(gamm_model)
}
\arguments{
\item{gamm_model}{The ‘gam‘ sublist from a model object of class \code{gamm}.}
}
\value{
The function returns a numerical vector of the same length then the
data used for the GAMM fitting, with one D value for each IND observation.
}
\description{
\code{cooks_dist_gamm} is a helper function for \code{\link{model_gamm}} and
\code{\link{plot_diagnostics}} and calculates the Cook`s distance for objects
of class `gamm`. The Cook`s distance D is a leave-one-out deletion diagnostics
to measure the influence of each observation. The generic \code{cooks.distance}
function does not work on the class `gamm`.
}
\examples{
# Using a model of the Baltic Sea demo data
cooks_dist_gamm(gamm_model = model_gamm_ex$model[[49]]$gam)
}
\seealso{
\code{\link{plot_diagnostics}}, \code{\link{model_gamm}}
}
\keyword{internal}
