% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.RT.ECDF_Single_Func}
\alias{Plot.RT.ECDF_Single_Func}
\alias{Plot.RT.ECDF_Single_Func.DataSetList}
\title{Plot the aggregated empirical cumulative distriburtion as a function of the running times of
a DataSetList.}
\usage{
Plot.RT.ECDF_Single_Func(dsList, fstart = NULL, fstop = NULL,
  fstep = NULL, show.per_target = F, scale.xlog = F)

\method{Plot.RT.ECDF_Single_Func}{DataSetList}(dsList, fstart = NULL,
  fstop = NULL, fstep = NULL, show.per_target = F, scale.xlog = F)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{fstart}{The starting function value}

\item{fstop}{The final function value}

\item{fstep}{The spacing between starting and final function values}

\item{show.per_target}{Whether or not to show the individual ECDF-curves for each target}

\item{scale.xlog}{Whether or not to scale the x-axis logaritmically}
}
\value{
A plot of the empirical cumulative distriburtion as a function of
the running times of the DataSetList
}
\description{
Plot the aggregated empirical cumulative distriburtion as a function of the running times of
a DataSetList.
}
\examples{
Plot.RT.ECDF_Single_Func(subset(dsl, funcId == 1))
}
