% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{plot_general_data}
\alias{plot_general_data}
\title{General function for plotting within IOHanalyzer}
\usage{
plot_general_data(df, x_attr = "algId", y_attr = "vals",
  type = "violin", legend_attr = "algId", scale.xlog = F,
  scale.ylog = F, scale.reverse = F, p = NULL, x_title = NULL,
  y_title = NULL, plot_title = NULL, upper_attr = NULL,
  lower_attr = NULL, subplot_attr = NULL, show.legend = F,
  inf.action = "none", ...)
}
\arguments{
\item{df}{The dataframe containing the data to plot. It should contain at least two columns:
'x_attr' and 'y_attr'}

\item{x_attr}{The column to specify the x_axis. Default is 'algId'}

\item{y_attr}{The column to specify the y_axis}

\item{type}{The type of plot to use. Currently available: 'violin', 'line', 'radar', 
'bar', hist' and 'ribbon'}

\item{legend_attr}{Default is 'algId' This is also used for the selection of colorschemes}

\item{scale.xlog}{Logarithmic scaling of x-axis}

\item{scale.ylog}{Logarithmic scaling of y-axis}

\item{scale.reverse}{Decreasing or increasing x-axis}

\item{p}{A previously existing plot on which to add traces. If NULL, a new canvas is created}

\item{x_title}{Title of x-axis. Defaults to x_attr}

\item{y_title}{Title of x-axis. Defaults to x_attr}

\item{plot_title}{Title of x-axis. Defaults to no title}

\item{upper_attr}{When using ribbon-plot, this can be used to create a shaded area. 
Only works in combination with`lower_attr` and `type` == 'ribbon'}

\item{lower_attr}{When using ribbon-plot, this can be used to create a shaded area. 
Only works in combination with`upper_attr` and `type` == 'ribbon'}

\item{subplot_attr}{Which attribute of the dataframe to use for creating subplots}

\item{show.legend}{Whether or not to include a legend}

\item{inf.action}{How to deal with infinite values. Can be 'none', 'overlap' or 'jitter'}

\item{...}{Additional parameters for the add_trace function}
}
\description{
General function for plotting within IOHanalyzer
}
