% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.html.R
\name{save.html}
\alias{save.html}
\title{Generate HTML file for clustering result in text mode}
\usage{
save.html(output.dir)
}
\arguments{
\item{output.dir}{A result directory as the \code{$output} object returned
from the \code{\link{ipcaps}} function.}
}
\value{
\code{NULL}
}
\description{
Generate HTML file called 'tree_text.html' from the result of
\code{\link{ipcaps}}. The clustering result is shown as a tree rendering by
the online Google Organizational Chart library. Note that the Internet is
required to view the HTML file.
}
\details{
After running, this function generates the file called 'tree_text.html' in the
same result directory.
}
\examples{

# Importantly, bed file, bim file, and fam file are required
# Use the example files embedded in the package

\donttest{
BED.file <- system.file("extdata","IPCAPS_example.bed",package="IPCAPS")
LABEL.file <- system.file("extdata","IPCAPS_example_individuals.txt",package="IPCAPS")

my.cluster <- ipcaps(bed=BED.file,label.file=LABEL.file,lab.col=2,out=tempdir())

#Here, to generate HTML file
save.html(my.cluster$output.dir)
}
}
\seealso{
\code{\link{save.plots}},
\code{\link{save.plots.cluster.html}},
\code{\link{save.eigenplots.html}},
and \code{\link{save.plots.label.html}}
}
