% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipcaps.R
\name{ipcaps}
\alias{ipcaps}
\title{Perform unsupervised clustering to capture population structure based on iterative pruning}
\usage{
ipcaps(
  bed = NA,
  rdata = NA,
  files = NA,
  label.file = NA,
  lab.col = 1,
  out,
  plot.as.pdf = FALSE,
  method = "mix",
  missing = NA,
  covariate = NA,
  cov.col.first = NA,
  cov.col.last = NA,
  threshold = 0.18,
  min.fst = 8e-04,
  min.in.group = 20,
  no.plot = FALSE
)
}
\arguments{
\item{bed}{A PLINK binary format consists of 3 files; bed, bim, and fam. To
generate these files from PLINK, use option –make-bed. See more details at:
\url{http://zzz.bwh.harvard.edu/plink/data.shtml}.}

\item{rdata}{In case of re-analysis, it is convenient to run IPCAPS using the
file rawdata.RData generated by IPCAPS. This file contains a matrix of SNPs
(raw.data) and a vector of labels (label).}

\item{files}{IPCAPS supports SNPs encoded as 0, 1 and 2 (dosage encoding).
Rows represent SNPs and columns represent subjects. Each column needs to be
separated by a space or a tab. A big text file should be divided into smaller
files to load faster. For instance, to input 3 files, use as: files=c(
'input1.txt', 'input2.txt', 'input3.txt').}

\item{label.file}{An additional useful information (called "labels" in
IPCAPS) related subject, for example, geographic location or disease
phenotype. These labels (one at a time) are used in displaying the clustering
outcome of IPCAPS. A label file must contain at least one column. However,
it may contain more than one column in which case each column need to be
separated by a space or a tab.}

\item{lab.col}{The label in the label file to be used in the tree-like
display of IPCAPS clustering results.}

\item{out}{To set an absolute path for IPCAPS output. If the specified output
directory already exists, result files are saved in sub-directories
cluster_out, cluster_out1, cluster_out2, etc.}

\item{plot.as.pdf}{To export plots as PDF. When omitted, plots are saved as PNG.}

\item{method}{The internal clustering method. It can be set to "mix"
(rubikclust & mixmod), "mixmod" (Lebret et al., 2015), "clara" (R: Clustering
Large Applications), "pam" (R: Partitioning Around Medoids (PAM) Object),
"meanshift" (Wang, 2016), "apcluster" (Bodenhofer et al., 2016), and "hclust"
(R: Hierarchical Clustering). Default = "mix".}

\item{missing}{Symbol used for missing genotypes. Default = NA.}

\item{covariate}{A file of covariates; one covariate per column. SNPs can be
adjusted for these covariates via regression modeling and residual
computation.}

\item{cov.col.first}{Refer to a covariate file, the first covariate to be
considered as confounding variable.}

\item{cov.col.last}{Refer to a covariate file, the last covariate to be
considered as confounding variable. All the variables in between the
cov.col.first and cov.col.last will be considered in the adjustment process.}

\item{threshold}{Cutoff value for EigenFit. Possible values range from 0.03
to 0.18. The smaller, the potentially finer the substructure can be. Default
= 0.18.}

\item{min.fst}{Minimum Fst between a pair of subgroups. Default = 0.0008.}

\item{min.in.group}{Minimum number of individuals to constitute a cluster or
subgroup. Default = 20.}

\item{no.plot}{No plot is generated if this option is TRUE. This option is
useful when the system does not support X Windows in the unix based system.
Default = FALSE.}
}
\value{
Returns the list object containing 2 internal objects;
output.dir as class character and cluster as class data.frame. The object
output.dir stores a result directory. The object cluster contains 4 columns,
group, node, label, and row.number. The column group contains the assigned
groups from IPCAPS. The column node contains node numbers in a tree as
illustrated in the HTML result files. The column label contains the given
labels that is set to the parameter label. The column row.number contains
indices to an input data, which is matched to row numbers of input matrix.
All clustering result files are saved in one directory (as specified by out)
containing assigned groups, hierarchical trees of group membership, PC plots,
and binary data for further analysis.
\itemize{
\item \code{$snp} is a SNP matrix from BED file.
\item \code{$snp.info} is a data.frame of SNP information from BIM file.
\item \code{$ind.info} is a data.frame of individual information from FAM file.
}
If function return \code{NULL}, it means the input files are not in proper
format.
}
\description{
This version supports ordinal data which can be applied directly
to SNP data to identify fine-scale population structure. It was built on the
iterative pruning Principal Component Analysis (ipPCA) algorithm
(Intarapanich et al., 2009; Limpiti et al., 2011). The IPCAPS involves an
iterative process using multiple splits based on multivariate Gaussian
mixture modeling of principal components and Clustering EM estimation (Lebret
et al., 2015). In each iteration, rough clusters and outliers are also
identified using our own method called rubikclust (R package \pkg{KRIS}).
}
\details{
The computational time depends on the number of individuals.
Consequentially, if large data sets are analyzed, it may be necessary first
to split data into smaller files, and then load into computer memory (with
parameter 'files'). Internally, the split files are merged to construct
a com-prehensive matrix.
}
\examples{

#Use the BED format as input
#Importantly, bed file, bim file, and fam file are required
#Use the example files embedded in the package

BED.file <- system.file("extdata", "ipcaps_example.bed", package = "IPCAPS")
LABEL.file <- system.file("extdata", "ipcaps_example_individuals.txt.gz",
                          package = "IPCAPS")
my.cluster1 <- ipcaps(bed = BED.file, label.file = LABEL.file, lab.col = 2,
out = tempdir())

table(my.cluster1$cluster$label, my.cluster1$cluster$group)

# Alternatively, use a text file as input
# Use the example files embedded in the package

#text.file <- system.file("extdata", "ipcaps_example_rowVar_colInd.txt.gz",
#                          package="IPCAPS")
#LABEL.file <- system.file("extdata", "ipcaps_example_individuals.txt.gz",
#                           package="IPCAPS")

#my.cluster2 <- ipcaps(files = c(text.file), label.file = LABEL.file, lab.col = 2,
#                       out=tempdir())
#table(my.cluster2$cluster$label, my.cluster2$cluster$group)

# The other alternative way, use an R Data file as input
# Use the example file embedded in the package

#rdata.file <- system.file("extdata", "ipcaps_example.rda", package = "IPCAPS")

#my.cluster3 <- ipcaps(rdata = rdata.file, out = tempdir())
#table(my.cluster3$cluster$label, my.cluster3$cluster$group)

}
\references{
Bodenhofer, U., Palme, J., Melkonian, C., and Kothmeier, A. (2016). apcluster
: Affinity Propagation Clustering. Available at: \url{ https://CRAN.R-project.
org/package=apcluster} (Accessed March 7, 2017).

Intarapanich, A., Shaw, P. J., Assawamakin, A., Wangkumhang, P., Ngamphiw, C.
, Chaichoompu, K., et al. (2009). Iterative pruning PCA improves resolution
of highly structured populations. BMC Bioinformatics 10, 382. doi:10.1186/
1471-2105-10-382.

Lebret, R., Iovleff, S., Langrognet, F., Biernacki, C., Celeux, G., and
Govaert, G. (2015). Rmixmod: TheRPackage of the Model-Based Unsupervised,
Supervised, and Semi-Supervised ClassificationMixmodLibrary. J. Stat. Softw.
67. doi:10.18637/jss.v067.i06.

Limpiti, T., Intarapanich, A., Assawamakin, A., Shaw, P. J., Wangkumhang, P.,
Piriyapongsa, J., et al. (2011). Study of large and highly stratified
population datasets by combining iterative pruning principal component
analysis and structure. BMC Bioinformatics 12, 255. doi:10.1186/1471-2105-12-
255.

Maechler, M., Rousseeuw, P., Struyf, A., Hubert, M., and Hornik, K. (2017).
cluster: Cluster Analysis Basics and Extensions.

R: Clustering Large Applications Available at: \url{https://stat.ethz.ch/
R-manual/R-devel/library/cluster/html/clara.html} (Accessed March 7, 2017).

R Core Team (2017). R: A Language and Environment for Statistical Computing.
Vienna, Austria: R Foundation for Statistical Computing Available at:
\url{https://www.R-project.org/}.

R: Hierarchical Clustering Available at: \url{https://stat.ethz.ch/R-manual/
R-devel/library/stats/html/hclust.html} (Accessed March 7, 2017).

R: Partitioning Around Medoids (PAM) Object Available at: \url{https://stat.
ethz.ch/R-manual/R-devel/library/cluster/html/pam.object.html} (Accessed
March 7, 2017).

Wang, M. C. and D. (2016). MeanShift: Clustering via the Mean Shift
Algorithm. Available at: \url{https://CRAN.R-project.org/package=MeanShift}
(Accessed March 7, 2017).
}
