% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irtpp.R
\name{irtpp}
\alias{irtpp}
\title{Estimate a test item parameters.}
\usage{
irtpp(dataset = NULL, model, dims = 1, initialvalues = NULL,
  filename = NULL, output = NULL, loglikflag = F,
  convergenceEpsilon = 1e-04)
}
\arguments{
\item{dataset}{The matrix with the responses from the individuals.}

\item{model}{The model used to calibrate the parameters.}

\item{dims}{The dimensions to use on the estimation, remember to use the initial parameters if you want highquality estimation.}

\item{initialvalues}{The matrix with the initial values for the optimization process.}

\item{filename}{Optional argument specifying a CSV file to read instead of a dataset in memory.}

\item{output}{Optional.  Additonal arguments that need.}

\item{loglikflag}{Optional. Show the loglikelihood at the end of estimation procedure. Also shows AIC and BIC statistic.}

\item{convergenceEpsilon}{Optional. Convergence value, default value of 1E-4}
}
\value{
A list containing the estimates of the model parameters, 
the number of iterations, the loglikelihood final, the final values
of the estimation procedure EM.
}
\description{
Estimate a test item parameters according to Item Response Theory.
}
\examples{
## Simulation data for the model "1pl"
# data <- simulateTest(model = "1PL", items = 10, individuals = 500)
## Estimation of the parameters
# irtpp(dataset = data$test, model = "1PL")

## Simulation data for the model "2pl"
# data <- simulateTest(model = "2PL", items = 20, individuals = 800)
## Estimation of the parameters
# irtpp(dataset = data$test, model = "2PL")

## Simulation data for the model "3pl"
# data <- simulateTest(model = "3PL", items = 100, individuals = 1000)
## Estimation of the parameters
# irtpp(dataset = data$test, model = "3PL") 
}

