% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulateTest.file}
\alias{simulateTest.file}
\title{This function simulates tests according to a IRT model.}
\usage{
simulateTest.file(model = "2PL", items = 10, individuals = 1000,
  reps = 1, dims = 1, filename = "test", directory = NULL,
  boundaries = NULL, itempars = NULL, latentTraits = NULL, seed = NULL,
  verbose = F, threshold = 0)
}
\arguments{
\item{model}{A string with the model to simulate, please refer to the model documentation in irtpp documentation.}

\item{items}{the number of items to simulate}

\item{individuals}{the number of individuals to simulate}

\item{reps}{The number of tests to generate with this settings}

\item{dims}{Optional. The number of dimensions to simulate in the test if the model is multidimensional TODO (Untested in multidimensional, please do not use this parameter for now)}

\item{filename}{A name to give the tests.}

\item{directory}{The directory to output the tests}

\item{boundaries}{Optional. The kind of boundaries that are specified for the parameters.}

\item{itempars}{Optional. Item parameters to be used in the simulation. When the parameters are not generated, the item parameters must be specified.}

\item{latentTraits}{A set of latent traits to set them for the individuals}

\item{seed}{Optional. Seed to use to generate all the data}

\item{verbose}{Optional. If true, output is made to know the status of the algorithm}

\item{threshold}{The threshold that indicates the boundaries on the individual scores (to avoid nearly perfect or nearly )}
}
\value{
A List with the model, the seed, the item parameters and the test.
}
\description{
Simulates a test according to a model and saves it to files, can be slow due to disk usage.
}
\examples{
# simulateTest.file("3PL", 20, 300)
}
\seealso{
\code{\link{simulateTest}}
}

