% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{compile}
\alias{compile}
\title{Compile ISRaD data product}
\usage{
compile(dataset_directory, write_report = FALSE, write_out = FALSE,
  return_type = c("none", "list")[2], checkdoi = F, verbose = T)
}
\arguments{
\item{dataset_directory}{Directory where completed QAQCed template files are stored.}

\item{write_report}{Boolean flag to write a log file of the
compilation. File will be in the specified
dataset_directory at "database/ISRaD_log.txt". If a file with this name already
exists in this directory it will be overwritten.}

\item{write_out}{Set to TRUE to write the compiled database file in .xlsx format
in dataset_directory}

\item{return_type}{A string that defines return object.
Acceptable values are "none" or "list"; default is "list".}

\item{checkdoi}{Set to FALSE if you do not want to validate DOIs during QAQC. (Warning: time consuming).}

\item{verbose}{Set to TRUE to print results of function to console.}
}
\description{
Compiles template files into ISRaD database format.
}
\examples{
\donttest{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Save as .xlsx file
ISRaD.save.xlsx(database = database,
 template_file = system.file("extdata", "ISRaD_Master_Template.xlsx", package = "ISRaD"),
 outfile = paste0(tempdir(),"/Gaudinski_2001.xlsx"))
# Compile .xlsx file/s in dataset_directory into ISRaD database object
ISRaD.compiled <- compile(tempdir(), write_report = TRUE, write_out = TRUE,
                          return_type = 'list', checkdoi = FALSE, verbose = TRUE)
}
}
