% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNproperties_function.R
\name{ITNproperties}
\alias{ITNproperties}
\title{ITN Properties}
\usage{
ITNproperties(gs)
}
\arguments{
\item{gs}{International Trade Network - igraph object}
}
\value{
Table of centrality results (dataframe)
}
\description{
This function calculates network level properties for the ITN. These include:
-Size (number of nodes) -Density -Reciprocity -Diameter
-Average path length -Average node strength -Average Degree
-Betweenness Centralisation -Closeness Centralisation -Eigenvector Centralisation
-Out Degree Centralisation -In Degree Centralisation -All Degree Centralisation -Clustering coefficent (transitivity)
-Clustering Weighted -Region Homophily -Degree Assortativity
}
\examples{
##Load the network
data(ELEnet16)

##Calculate the network properties
ITNPROP<-ITNproperties(ELEnet16)

}
