% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesicAreas.R
\name{getArea}
\alias{getArea}
\title{Calculate geodesic area}
\usage{
getArea(myPoly, byid = FALSE)
}
\arguments{
\item{myPoly}{\code{SpatialPolygons} object to calculate area of}

\item{byid}{boolean indicating whether areas should be calculated for each polygon or for the whole object together}
}
\value{
Area (or vector of areas if \code{byid} is set to \code{TRUE})
}
\description{
Caclulate the geodesic areas of \code{SpatialPolygons} object on the Nothern Hemisphere Polar Stereographic projection
}
\details{
Area calculations are for the Polar stereographic grid with major axis of 6378273m and
ellipsoid flattening of 1/298.2794111.
}
\examples{
getArea(regionInfo$regions[[1]])
}
\references{
Information on Polar Stereographic North projection: \url{https://nsidc.org/data/atlas/epsg_3411.html}
}
