% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBootstrap.R
\name{readMonthlyBS}
\alias{readMonthlyBS}
\title{Read in a set of bootstrap observations over a set of year}
\usage{
readMonthlyBS(startYear, endYear, fileFolder, nX = 304, nY = 448)
}
\arguments{
\item{startYear}{first year to read in}

\item{endYear}{lastYear to read in}

\item{fileFolder}{Folder in which binary files are stored}

\item{nX}{longitude dimension}

\item{nY}{latitude dimension}
}
\value{
Bootstrap observations sorted into array of dimension: year x month x lon x lat
}
\description{
Function to process monthly bootstrap data over multiple years. The observations are from the monthly sea ice concentration
obtained from the National Aeronautics and Space Administration (NASA) satellites Nimbus-7
SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm. The results
are distributed by the National Snow and Ice Data Center (Comiso 2000, updated 2015).
Functions assume file name conventions are the same as used by NSIDC.
}
\details{
Raw binary files for 2012-2013 are included in the package
}
\examples{
\dontrun{
#myFilePath should be a file path where the 1983 binary files are stored
observedDemo <- readMonthlyBS(startYear = 1983, endYear = 1983, fileFolder = myFilePath)
}
}
\references{
Bootstrap sea ice concentration:

Comiso, J., 2000, updated 2015: Bootstrap sea ice concentrations from Nimbus-7 SMMR and
DMSP SSM/I-SSMIS. version 2. \url{http://nsidc.org/data/nsidc-0079}
}
