# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Run MCMC to Fit Contour Model
#'
#' @param n_iter   number of iterations to run the MCMC
#' @param dists symmetric matrix of the same dimension as the number of
#'                lines being used, specifying distances among starting locations
#'                or angles.
#' @param x a matrix of observed distances (y) of dimension number
#'          of vectors by number of years
#' @param xU_vecs vector giving the indices of each x value vector in each year
#'               that is not observed (vector indices and year indices are
#'               paired, so must be ordered the same as xU_years)
#' @param xU_years vector giving the indices of each year in which each x value
#'                vector is not observed (vector indices and year indices are
#'                paired, so must be ordered the same as xU_vecs)
#' @param xU_prop_sd Standard deviation for proposals for xU
#' @param xU_lb Lower bounds for xU values being sampled (order must match
#'             orded of xU_vecs and xU_years)
#' @param xU_ub Upper bounds for xU values being sampled (order must match
#'             orded of xU_vecs and xU_years)
#' @param mu vector of the same length as the number of lines which specifies
#'           the values from which each element of \code{mu} will be initialized
#'           in the MCMC.
#' @param mu0 vector of the same length as the number of lines which specifies
#'            the prior mean for \code{mu}.
#' @param lambda0 matrix of the same dimension as the number of lines which
#'                specifices the prior covariance matrix for \code{mu}.
#' @param sigma vector of the same length as the number of lines which
#'              specifies the values from which each element in \code{sigma}
#'              will be initialized from
#' @param sigma_ind_1 vector giving the first index of each section of sigma's
#'                  to be sampled together
#' @param sigma_ind_2 vector giving the last index of each section of sigma's
#'                  to be sampled together
#' @param sigma_prop_cov covariance matrix of the same length as the number of
#'                     lines that is used in sampling \code{sigma} values
#' @param rho double between 0 and 1 from which the value of \code{rho} will
#'             be initialized
#' @param rho0_lb double between 0 and 1 which gives the lower bound of the
#'               uniform prior for \code{rho}
#' @param rho0_ub double between 0 and 1 which gives the upper bound of the
#'               uniform prior for \code{rho}.
#' @param rho_prop_sd standard deviation for the normal proposal distribution used
#'                  when proposing value for \code{rho} in the sampler. Defaults
#'                  to 0.01
#' @param sigma0_lb vector of the same length as the number of lines which
#'                 specifies the lower bound of the uniform prior for each
#'                 sigma value
#' @param sigma0_ub vector of the same length as the number of lines which
#'                 specifies the upper bound of the uniform prior for each sigma
#'                 value.
#' @param w Integer specifying how many samples of the parameters will be
#'           maintained. Samples from every wth iteration is stored.
#'
#' @return List of length 7 that gives the values of the MCMC chain for
#'         \code{xU}, \code{mu}, \code{sigma} and \code{rho} along with
#'         indicators of acceptance on each iteration: \code{xURate},
#'         \code{sigmaRate}, and \code{rhoRate}.
RunMCMC <- function(n_iter, dists, x, xU_vecs, xU_years, xU_prop_sd, xU_lb, xU_ub, mu, mu0, lambda0, sigma, sigma_ind_1, sigma_ind_2, sigma_prop_cov, rho, rho0_lb, rho0_ub, rho_prop_sd, sigma0_lb, sigma0_ub, w) {
    .Call('_IceCast_RunMCMC', PACKAGE = 'IceCast', n_iter, dists, x, xU_vecs, xU_years, xU_prop_sd, xU_lb, xU_ub, mu, mu0, lambda0, sigma, sigma_ind_1, sigma_ind_2, sigma_prop_cov, rho, rho0_lb, rho0_ub, rho_prop_sd, sigma0_lb, sigma0_ub, w)
}

