% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storedResults.R
\docType{data}
\name{discrep}
\alias{discrep}
\title{Discrepancy maps for September 1993-2007 (lead time 2.5-months)}
\format{Object obtained from the \code{createMapping} function (see details)}
\usage{
discrep
}
\description{
The object \code{discrep} is obtained from running the \code{createMapping}
function for September 1993-2007. The predictions used are from European Center
for Medium-Range Weather Forecasts (ECMWF) at a 2.5-month lead time and are
converted to a Polar Stereographic grid. Model output is available from
the Sea Ice Prediction Network Predicatability Portal or the Copernicus
Climate Change Service data store. The observations used are from the monthly
sea ice concentration obtained fromthe National Aeronautics and Space
Administration (NASA) satellites Nimbus-7 SMMR and DMSP SSM/I-SSMIS and
processed by the bootstrap algorithm. The results are distributed by the
National Snow and Ice Data Center (Comiso 2017).
}
\details{
The object \code{discrep} is obtained from running the
         \code{createMapping} function. It is a list of four objects where
         \code{startYear} and \code{endYear} give the
         first year and last year that were mapped. The variables
         \code{obsList} and \code{predList} are lists of arrays with one
         3-dimensional array for each region. The first dimension is for the
         year. The other two dimensions are for the fixed points'
         y-coordinates, the mapped points' x-coordinates, the mapped points'
         y-coordinates, the length of the mapping vectors in the x-direction,
         the length of the vectors in the y-direction, and the angles of the
         mapping vectors.
}
\examples{
data(discrep)
names(discrep)
}
\references{
Comiso, J., 2017: Bootstrap sea ice concentrations
            from Nimbus-7 SMMR and DMSP SSM/I-SSMIS. version 3.
            Boulder, Colorado USA: NASA National Snow and Ice Data Center
            Distributed Active Archive Center. doi: \url{https://doi.org/10.5067/7Q8HCCWS4I0R}

            Copernicus Climate Change Service (2019). Description of the c3s
            seasonal multi-system.\url{https://confluence.ecmwf.int/display/COPSRV/Description+of+the+C3S+seasonal+multi-system}

            Sea Ice Prediction Network (2019). Sea ice prediction network
            predictability portal. \url{https://atmos.uw.edu/sipn/.}
}
\keyword{datasets}
